/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.zip.CRC32;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dromara.pdf.shade.org.apache.fontbox.FontBoxFont;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.FontHeaders;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.OS2WindowsMetricsTable;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.OTFParser;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.OpenTypeFont;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.TTFParser;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.TrueTypeCollection;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.TrueTypeFont;
import org.dromara.pdf.shade.org.apache.fontbox.type1.Type1Font;
import org.dromara.pdf.shade.org.apache.fontbox.util.autodetect.FontFileFinder;
import org.dromara.pdf.shade.org.apache.pdfbox.io.IOUtils;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.CIDSystemInfo;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.FontCache;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.FontFormat;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.FontInfo;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.FontProvider;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.PDPanoseClassification;

final class FileSystemFontProvider
extends FontProvider {
    private static final Log LOG = LogFactory.getLog(FileSystemFontProvider.class);
    private final List<FSFontInfo> fontInfoList = new ArrayList<FSFontInfo>();
    private final Map<String, FontInfo> fontInfoByName = new TreeMap<String, FontInfo>();
    private final FontCache cache;

    private FSFontInfo createFSIgnored(File file, FontFormat format, String postScriptName) {
        String hash;
        try {
            hash = FileSystemFontProvider.computeHash(Files.newInputStream(file.toPath(), new OpenOption[0]));
        }
        catch (IOException ex) {
            hash = "";
        }
        return new FSFontInfo(file, format, postScriptName, postScriptName, null, 0, 0, 0, 0, 0, null, null, hash, file.lastModified());
    }

    FileSystemFontProvider(FontCache cache) {
        boolean scanDiskFont;
        this.cache = cache;
        boolean bl = scanDiskFont = !Objects.equals("false", System.getProperty("x-easypdf.font.scan"));
        if (scanDiskFont) {
            try {
                long begin = System.currentTimeMillis();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Will search the local system fonts");
                }
                FontFileFinder fontFileFinder = new FontFileFinder();
                List<URI> fonts = fontFileFinder.find();
                ArrayList<File> files = new ArrayList<File>(fonts.size());
                for (URI font : fonts) {
                    files.add(new File(font));
                }
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Found " + files.size() + " fonts on the local system"));
                }
                if (!files.isEmpty()) {
                    List<FSFontInfo> cachedInfos = this.loadDiskCache(files);
                    if (cachedInfos != null && !cachedInfos.isEmpty()) {
                        this.fontInfoList.addAll(cachedInfos);
                        cachedInfos.forEach(info -> {
                            this.fontInfoByName.put(info.getFontName(), (FontInfo)info);
                            this.fontInfoByName.put(info.getPostScriptName(), (FontInfo)info);
                        });
                    } else {
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)"Building on-disk font cache, this may take a while");
                        }
                        this.scanFonts(files);
                        this.saveDiskCache();
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("Finished building on-disk font cache, found " + this.fontInfoList.size() + " fonts"));
                        }
                    }
                }
                long end = System.currentTimeMillis();
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Finished loading local system fonts: " + (end - begin) + "ms"));
                }
            }
            catch (AccessControlException e) {
                LOG.error((Object)"Error accessing the file system", (Throwable)e);
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Skipped local system font search");
        }
    }

    @Override
    public String addFont(File file) {
        try {
            String filePath = file.getName().toLowerCase();
            if (filePath.endsWith(".ttf") || filePath.endsWith(".otf")) {
                this.addTrueTypeFont(file, FilenameUtils.getBaseName((String)file.getName()));
            } else if (filePath.endsWith(".ttc") || filePath.endsWith(".otc")) {
                this.addTrueTypeCollection(file, FilenameUtils.getBaseName((String)file.getName()));
            } else if (filePath.endsWith(".pfb")) {
                this.addType1Font(file, FilenameUtils.getBaseName((String)file.getName()));
            }
            return this.fontInfoList.isEmpty() ? "" : this.fontInfoList.get(this.fontInfoList.size() - 1).getFontName();
        }
        catch (Exception e) {
            LOG.error((Object)("Error parsing font " + file.getPath()), (Throwable)e);
            return "";
        }
    }

    @Override
    public String addFont(File file, String alias) {
        try {
            String filePath = file.getName().toLowerCase();
            if (filePath.endsWith(".ttf") || filePath.endsWith(".otf")) {
                this.addTrueTypeFont(file, alias);
            } else if (filePath.endsWith(".ttc") || filePath.endsWith(".otc")) {
                this.addTrueTypeCollection(file, alias);
            } else if (filePath.endsWith(".pfb")) {
                this.addType1Font(file, alias);
            }
            return this.fontInfoList.isEmpty() ? "" : this.fontInfoList.get(this.fontInfoList.size() - 1).getFontName();
        }
        catch (Exception e) {
            LOG.error((Object)("Error parsing font " + file.getPath()), (Throwable)e);
            return "";
        }
    }

    @Override
    public String addFont(InputStream inputStream, String alias, String type) {
        String fileName = alias + "." + type;
        try {
            File tempFile = new File(System.getProperty("java.io.tmpdir"), fileName);
            FileUtils.writeByteArrayToFile((File)tempFile, (byte[])IOUtils.toByteArray(inputStream));
            if (Objects.equals("ttf", type) || Objects.equals("otf", type)) {
                this.addTrueTypeFont(tempFile, alias);
            } else if (Objects.equals("ttc", type) || Objects.equals("otc", type)) {
                this.addTrueTypeCollection(tempFile, alias);
            } else if (Objects.equals("pfb", type)) {
                this.addType1Font(tempFile, alias);
            }
            return this.fontInfoList.isEmpty() ? "" : this.fontInfoList.get(this.fontInfoList.size() - 1).getFontName();
        }
        catch (Exception e) {
            LOG.error((Object)("Error parsing font " + type), (Throwable)e);
            return "";
        }
    }

    private void addTrueTypeFont(InputStream inputStream, String alias, String type) {
        String fileName = alias + "." + type;
        try {
            File tempFile = new File(System.getProperty("java.io.tmpdir"), fileName);
            FileUtils.writeByteArrayToFile((File)tempFile, (byte[])IOUtils.toByteArray(inputStream));
            this.addTrueTypeFont(tempFile, alias);
        }
        catch (Exception e) {
            LOG.error((Object)("Could not load font file: " + fileName));
        }
    }

    private void addTrueTypeCollection(InputStream inputStream, String alias, String type) {
        String fileName = alias + "." + type;
        try {
            File tempFile = new File(System.getProperty("java.io.tmpdir"), fileName);
            FileUtils.writeByteArrayToFile((File)tempFile, (byte[])IOUtils.toByteArray(inputStream));
            this.addTrueTypeCollection(tempFile, alias);
        }
        catch (Exception e) {
            LOG.error((Object)("Could not load font file: " + fileName));
        }
    }

    private void addTrueTypeFont(File file, String alias) {
        FontFormat fontFormat = null;
        try {
            TTFParser parser;
            if (file.getPath().toLowerCase().endsWith(".otf")) {
                fontFormat = FontFormat.OTF;
                parser = new OTFParser(false);
            } else {
                fontFormat = FontFormat.TTF;
                parser = new TTFParser(false);
            }
            FontHeaders headers = parser.parseTableHeaders(new RandomAccessReadBufferedFile(file));
            this.addTrueTypeFontImpl(headers, file, alias, FileSystemFontProvider.computeHash(Files.newInputStream(file.toPath(), new OpenOption[0])));
        }
        catch (IOException e) {
            LOG.warn((Object)("Could not load font file: " + file), (Throwable)e);
            this.fontInfoList.add(this.createFSIgnored(file, fontFormat, "*skipexception*"));
        }
    }

    private void scanFonts(List<File> files) {
        files.forEach(this::addFont);
    }

    private File getDiskCacheFile() {
        String path = System.getProperty("x-easypdf.font.cache.path");
        if (FileSystemFontProvider.isBadPath(path) && FileSystemFontProvider.isBadPath(path = System.getProperty("user.home"))) {
            path = System.getProperty("java.io.tmpdir");
        }
        return new File(path, ".x-easypdf.font.cache");
    }

    private static boolean isBadPath(String path) {
        return path == null || !new File(path).isDirectory() || !new File(path).canWrite();
    }

    private void saveDiskCache() {
        try {
            File file = this.getDiskCacheFile();
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                for (FSFontInfo fontInfo : this.fontInfoList) {
                    this.writeFontInfo(writer, fontInfo);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Could not write to font cache", (Throwable)e);
                LOG.warn((Object)"Installed fonts information will have to be reloaded for each start");
                LOG.warn((Object)"You can assign a directory to the 'pdfbox.fontcache' property");
            }
        }
        catch (Exception e) {
            LOG.debug((Object)"Couldn't create writer for font cache file", (Throwable)e);
        }
    }

    private void writeFontInfo(BufferedWriter writer, FSFontInfo fontInfo) throws IOException {
        writer.write(fontInfo.fontName.trim());
        writer.write("|");
        writer.write(fontInfo.postScriptName.trim());
        writer.write("|");
        writer.write(fontInfo.format.toString());
        writer.write("|");
        if (fontInfo.cidSystemInfo != null) {
            writer.write(fontInfo.cidSystemInfo.getRegistry() + '-' + fontInfo.cidSystemInfo.getOrdering() + '-' + fontInfo.cidSystemInfo.getSupplement());
        }
        writer.write("|");
        if (fontInfo.usWeightClass > -1) {
            writer.write(Integer.toHexString(fontInfo.usWeightClass));
        }
        writer.write("|");
        if (fontInfo.sFamilyClass > -1) {
            writer.write(Integer.toHexString(fontInfo.sFamilyClass));
        }
        writer.write("|");
        writer.write(Integer.toHexString(fontInfo.ulCodePageRange1));
        writer.write("|");
        writer.write(Integer.toHexString(fontInfo.ulCodePageRange2));
        writer.write("|");
        if (fontInfo.macStyle > -1) {
            writer.write(Integer.toHexString(fontInfo.macStyle));
        }
        writer.write("|");
        if (fontInfo.panose != null) {
            byte[] bytes = fontInfo.panose.getBytes();
            for (int i = 0; i < 10; ++i) {
                String str = Integer.toHexString(bytes[i]);
                if (str.length() == 1) {
                    writer.write(48);
                }
                writer.write(str);
            }
        }
        writer.write("|");
        writer.write(fontInfo.file.getAbsolutePath());
        writer.write("|");
        writer.write(fontInfo.hash);
        writer.write("|");
        writer.write(Long.toString(fontInfo.file.lastModified()));
        writer.newLine();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<FSFontInfo> loadDiskCache(List<File> files) {
        HashSet<String> pending = new HashSet<String>(files.size());
        for (File file : files) {
            pending.add(file.getAbsolutePath());
        }
        ArrayList<FSFontInfo> results = new ArrayList<FSFontInfo>();
        File diskCacheFile = null;
        boolean fileExists = false;
        try {
            diskCacheFile = this.getDiskCacheFile();
            fileExists = diskCacheFile.exists();
        }
        catch (SecurityException e) {
            LOG.debug((Object)"Error checking for file existence", (Throwable)e);
        }
        if (fileExists) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(diskCacheFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
                String line;
                File lastFile = null;
                String lastHash = null;
                while ((line = reader.readLine()) != null) {
                    File fontFile;
                    block37: {
                        String[] parts = line.split("\\|", 13);
                        if (parts.length < 12) {
                            LOG.warn((Object)("Incorrect line '" + line + "' in font disk cache is skipped"));
                            continue;
                        }
                        CIDSystemInfo cidSystemInfo = null;
                        int usWeightClass = -1;
                        int sFamilyClass = -1;
                        int macStyle = -1;
                        byte[] panose = null;
                        String hash = "";
                        long lastModified = 0L;
                        String fontName = parts[0];
                        String postScriptName = parts[1];
                        FontFormat format = FontFormat.valueOf(parts[2]);
                        if (parts[3].length() > 0) {
                            String[] ros = parts[3].split("-");
                            cidSystemInfo = new CIDSystemInfo(ros[0], ros[1], Integer.parseInt(ros[2]));
                        }
                        if (parts[4].length() > 0) {
                            usWeightClass = (int)Long.parseLong(parts[4], 16);
                        }
                        if (parts[5].length() > 0) {
                            sFamilyClass = (int)Long.parseLong(parts[5], 16);
                        }
                        int ulCodePageRange1 = (int)Long.parseLong(parts[6], 16);
                        int ulCodePageRange2 = (int)Long.parseLong(parts[7], 16);
                        if (parts[8].length() > 0) {
                            macStyle = (int)Long.parseLong(parts[8], 16);
                        }
                        if (parts[9].length() > 0) {
                            panose = new byte[10];
                            for (int i = 0; i < 10; ++i) {
                                String str = parts[9].substring(i * 2, i * 2 + 2);
                                int b = Integer.parseInt(str, 16);
                                panose[i] = (byte)(b & 0xFF);
                            }
                        }
                        fontFile = new File(parts[10]);
                        if (parts.length >= 12 && !parts[11].isEmpty() && !parts[12].isEmpty()) {
                            hash = parts[10];
                            lastModified = Long.parseLong(parts[12]);
                        }
                        if (fontFile.exists()) {
                            boolean keep;
                            boolean bl = keep = fontFile.lastModified() == lastModified;
                            if (!keep) {
                                String newHash;
                                if (hash.equals(lastHash) && fontFile.equals(lastFile)) {
                                    newHash = lastHash;
                                } else {
                                    try {
                                        newHash = FileSystemFontProvider.computeHash(Files.newInputStream(fontFile.toPath(), new OpenOption[0]));
                                        lastFile = fontFile;
                                        lastHash = newHash;
                                    }
                                    catch (IOException ex) {
                                        LOG.debug((Object)("Error reading font file " + fontFile.getAbsolutePath()), (Throwable)ex);
                                        newHash = "<err>";
                                    }
                                }
                                if (hash.equals(newHash)) {
                                    keep = true;
                                    lastModified = fontFile.lastModified();
                                }
                            }
                            if (keep) {
                                FSFontInfo info = new FSFontInfo(fontFile, format, fontName, postScriptName, cidSystemInfo, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this, hash, lastModified);
                                results.add(info);
                                break block37;
                            } else {
                                LOG.debug((Object)("Font file " + fontFile.getAbsolutePath() + " is different"));
                                continue;
                            }
                        }
                        LOG.debug((Object)("Font file " + fontFile.getAbsolutePath() + " not found, skipped"));
                    }
                    pending.remove(fontFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                LOG.warn((Object)"Error loading font cache, will be re-built", (Throwable)e);
                return null;
            }
        }
        if (!pending.isEmpty()) {
            LOG.info((Object)(pending.size() + " new font files found, font cache will be re-built"));
            return null;
        }
        return results;
    }

    private void addTrueTypeCollection(File ttcFile, String alias) {
        try {
            String hash = FileSystemFontProvider.computeHash(Files.newInputStream(ttcFile.toPath(), new OpenOption[0]));
            TrueTypeCollection.processAllFontHeaders(ttcFile, fontHeaders -> this.addTrueTypeFontImpl(fontHeaders, ttcFile, alias, hash));
        }
        catch (Exception e) {
            this.fontInfoList.add(this.createFSIgnored(ttcFile, FontFormat.TTF, "*skipexception*"));
            LOG.warn((Object)("Could not load font file: " + ttcFile));
        }
    }

    private void addTrueTypeFontImpl(FontHeaders fontHeaders, File file, String alias, String hash) {
        String error = fontHeaders.getError();
        if (error == null) {
            String name = fontHeaders.getName();
            if (name != null && name.contains("|")) {
                this.fontInfoList.add(this.createFSIgnored(file, FontFormat.TTF, "*skippipeinname*"));
                LOG.warn((Object)("Skipping font with '|' in name " + name + " in file " + file));
            } else if (name != null) {
                FontFormat format;
                Integer macStyle = fontHeaders.getHeaderMacStyle();
                if (macStyle == null) {
                    this.fontInfoList.add(this.createFSIgnored(file, FontFormat.TTF, name));
                    return;
                }
                int sFamilyClass = -1;
                int usWeightClass = -1;
                int ulCodePageRange1 = 0;
                int ulCodePageRange2 = 0;
                byte[] panose = null;
                OS2WindowsMetricsTable os2WindowsMetricsTable = fontHeaders.getOS2Windows();
                if (os2WindowsMetricsTable != null) {
                    sFamilyClass = os2WindowsMetricsTable.getFamilyClass();
                    usWeightClass = os2WindowsMetricsTable.getWeightClass();
                    ulCodePageRange1 = (int)os2WindowsMetricsTable.getCodePageRange1();
                    ulCodePageRange2 = (int)os2WindowsMetricsTable.getCodePageRange2();
                    panose = os2WindowsMetricsTable.getPanose();
                }
                CIDSystemInfo ros = null;
                if (fontHeaders.isOpenTypePostScript()) {
                    format = FontFormat.OTF;
                    String registry = fontHeaders.getOtfRegistry();
                    String ordering = fontHeaders.getOtfOrdering();
                    if (registry != null || ordering != null) {
                        ros = new CIDSystemInfo(registry, ordering, fontHeaders.getOtfSupplement());
                    }
                } else {
                    byte[] bytes = fontHeaders.getNonOtfTableGCID142();
                    if (bytes != null) {
                        String reg = new String(bytes, 10, 64, StandardCharsets.US_ASCII);
                        String registryName = reg.substring(0, reg.indexOf(0));
                        String ord = new String(bytes, 76, 64, StandardCharsets.US_ASCII);
                        String orderName = ord.substring(0, ord.indexOf(0));
                        int supplementVersion = bytes[140] << 8 & (bytes[141] & 0xFF);
                        ros = new CIDSystemInfo(registryName, orderName, supplementVersion);
                    }
                    format = FontFormat.TTF;
                }
                FSFontInfo info = new FSFontInfo(file, format, this.getFontName(file, name), name, ros, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this, hash, file.lastModified());
                this.fontInfoList.add(info);
                this.fontInfoByName.put(info.getFontName(), info);
                this.fontInfoByName.put(info.getPostScriptName(), info);
                if (Objects.nonNull(alias)) {
                    this.fontInfoByName.put(alias, new FSFontInfo(file, format, alias, name, ros, usWeightClass, sFamilyClass, ulCodePageRange1, ulCodePageRange2, macStyle, panose, this, hash, file.lastModified()));
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Added font [name: '" + info.getFontName() + "', postScriptName: '" + info.getPostScriptName() + "', alias: '" + Optional.ofNullable(alias).orElse("") + "']"));
                }
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)(format.name() + ": '" + name + "' / '" + fontHeaders.getFontFamily() + "' / '" + fontHeaders.getFontSubFamily() + "'"));
                }
            } else {
                this.fontInfoList.add(this.createFSIgnored(file, FontFormat.TTF, "*skipnoname*"));
                LOG.warn((Object)("Missing 'name' entry for PostScript name in font " + file));
            }
        } else {
            this.fontInfoList.add(this.createFSIgnored(file, FontFormat.TTF, "*skipexception*"));
            LOG.warn((Object)("Could not load font file '" + file + "': " + error));
        }
    }

    private void addType1Font(File pfbFile, String alias) {
        try (InputStream input = Files.newInputStream(pfbFile.toPath(), new OpenOption[0]);){
            Type1Font type1 = Type1Font.createWithPFB(input);
            if (type1.getName() == null) {
                this.fontInfoList.add(this.createFSIgnored(pfbFile, FontFormat.PFB, "*skipnoname*"));
                LOG.warn((Object)("Missing 'name' entry for PostScript name in font " + pfbFile));
                return;
            }
            if (type1.getName().contains("|")) {
                this.fontInfoList.add(this.createFSIgnored(pfbFile, FontFormat.PFB, "*skippipeinname*"));
                LOG.warn((Object)("Skipping font with '|' in name " + type1.getName() + " in file " + pfbFile));
                return;
            }
            String hash = FileSystemFontProvider.computeHash(Files.newInputStream(pfbFile.toPath(), new OpenOption[0]));
            FSFontInfo info = new FSFontInfo(pfbFile, FontFormat.PFB, type1.getName(), type1.getName(), null, -1, -1, 0, 0, -1, null, this, hash, pfbFile.lastModified());
            this.fontInfoList.add(info);
            this.fontInfoByName.put(info.getFontName(), info);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Added font [name: '" + info.getFontName() + "', postScriptName: '" + info.getPostScriptName() + "', alias: '" + Optional.ofNullable(alias).orElse("") + "']"));
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("PFB: '" + type1.getName() + "' / '" + type1.getFamilyName() + "' / '" + type1.getWeight() + "'"));
            }
        }
        catch (Exception e) {
            this.fontInfoList.add(this.createFSIgnored(pfbFile, FontFormat.PFB, "*skipexception*"));
            LOG.warn((Object)("Could not load font file: " + pfbFile));
        }
    }

    @Override
    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        for (FSFontInfo info : this.fontInfoList) {
            sb.append((Object)info.getFormat());
            sb.append(": ");
            sb.append(info.getPostScriptName());
            sb.append(": ");
            sb.append(info.file.getPath());
            sb.append('\n');
        }
        return sb.toString();
    }

    @Override
    public List<? extends FontInfo> getFontInfo() {
        return this.fontInfoList;
    }

    @Override
    public Map<String, FontInfo> getFontInfoByName() {
        return this.fontInfoByName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String computeHash(InputStream is) throws IOException {
        CRC32 crc = new CRC32();
        try {
            int readBytes;
            byte[] buffer = new byte[4096];
            while ((readBytes = is.read(buffer)) != -1) {
                crc.update(buffer, 0, readBytes);
            }
            long hash = crc.getValue();
            String string = Long.toHexString(hash);
            return string;
        }
        finally {
            IOUtils.closeQuietly(is);
        }
    }

    private String getFontName(File file, String postScriptName) {
        String fontName;
        try {
            fontName = Font.createFont(0, file).getFontName();
        }
        catch (Exception e) {
            fontName = postScriptName;
        }
        return fontName;
    }

    private static class FSFontInfo
    extends FontInfo {
        private final String fontName;
        private final String postScriptName;
        private final FontFormat format;
        private final CIDSystemInfo cidSystemInfo;
        private final int usWeightClass;
        private final int sFamilyClass;
        private final int ulCodePageRange1;
        private final int ulCodePageRange2;
        private final int macStyle;
        private final PDPanoseClassification panose;
        private final File file;
        private final FileSystemFontProvider parent;
        private final String hash;
        private final long lastModified;

        private FSFontInfo(File file, FontFormat format, String fontName, String postScriptName, CIDSystemInfo cidSystemInfo, int usWeightClass, int sFamilyClass, int ulCodePageRange1, int ulCodePageRange2, int macStyle, byte[] panose, FileSystemFontProvider parent, String hash, long lastModified) {
            this.file = file;
            this.format = format;
            this.fontName = fontName;
            this.postScriptName = postScriptName;
            this.cidSystemInfo = cidSystemInfo;
            this.usWeightClass = usWeightClass;
            this.sFamilyClass = sFamilyClass;
            this.ulCodePageRange1 = ulCodePageRange1;
            this.ulCodePageRange2 = ulCodePageRange2;
            this.macStyle = macStyle;
            this.panose = panose != null && panose.length >= 10 ? new PDPanoseClassification(panose) : null;
            this.parent = parent;
            this.hash = hash;
            this.lastModified = lastModified;
        }

        @Override
        public String getFontName() {
            return this.fontName;
        }

        @Override
        public String getPostScriptName() {
            return this.postScriptName;
        }

        @Override
        public FontFormat getFormat() {
            return this.format;
        }

        @Override
        public CIDSystemInfo getCIDSystemInfo() {
            return this.cidSystemInfo;
        }

        @Override
        public FontBoxFont getFont() {
            FontBoxFont font;
            FontBoxFont cached = this.parent.cache.getFont(this);
            if (cached != null) {
                return cached;
            }
            switch (this.format) {
                case PFB: {
                    font = this.getType1Font(this.postScriptName, this.file);
                    break;
                }
                case TTF: {
                    font = this.getTrueTypeFont(this.postScriptName, this.file);
                    break;
                }
                case OTF: {
                    font = this.getOTFFont(this.postScriptName, this.file);
                    break;
                }
                default: {
                    throw new RuntimeException("can't happen");
                }
            }
            if (font != null) {
                this.parent.cache.addFont(this, font);
            }
            return font;
        }

        @Override
        public int getFamilyClass() {
            return this.sFamilyClass;
        }

        @Override
        public int getWeightClass() {
            return this.usWeightClass;
        }

        @Override
        public int getCodePageRange1() {
            return this.ulCodePageRange1;
        }

        @Override
        public int getCodePageRange2() {
            return this.ulCodePageRange2;
        }

        @Override
        public int getMacStyle() {
            return this.macStyle;
        }

        @Override
        public PDPanoseClassification getPanose() {
            return this.panose;
        }

        @Override
        public String toString() {
            return super.toString() + " " + this.file + " " + this.hash + " " + this.lastModified;
        }

        private TrueTypeFont getTrueTypeFont(String postScriptName, File file) {
            try {
                TrueTypeFont ttf = this.readTrueTypeFont(postScriptName, file);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
                }
                return ttf;
            }
            catch (IOException e) {
                LOG.warn((Object)("Could not load font file: " + file), (Throwable)e);
                return null;
            }
        }

        private TrueTypeFont readTrueTypeFont(String postScriptName, File file) throws IOException {
            if (file.getName().toLowerCase().endsWith(".ttc")) {
                TrueTypeFont ttf;
                TrueTypeCollection ttc = new TrueTypeCollection(file);
                try {
                    ttf = ttc.getFontByName(postScriptName);
                }
                catch (IOException ex) {
                    ttc.close();
                    throw ex;
                }
                if (ttf == null) {
                    ttc.close();
                    throw new IOException("Font " + postScriptName + " not found in " + file);
                }
                return ttf;
            }
            TTFParser ttfParser = new TTFParser(false);
            return ttfParser.parse(new RandomAccessReadBufferedFile(file));
        }

        private OpenTypeFont getOTFFont(String postScriptName, File file) {
            try {
                if (file.getName().toLowerCase().endsWith(".ttc")) {
                    TrueTypeFont ttf;
                    TrueTypeCollection ttc = new TrueTypeCollection(file);
                    try {
                        ttf = ttc.getFontByName(postScriptName);
                    }
                    catch (IOException ex) {
                        LOG.error((Object)ex.getMessage(), (Throwable)ex);
                        ttc.close();
                        return null;
                    }
                    if (ttf == null) {
                        ttc.close();
                        throw new IOException("Font " + postScriptName + " not found in " + file);
                    }
                    return (OpenTypeFont)ttf;
                }
                OTFParser parser = new OTFParser(false);
                OpenTypeFont otf = parser.parse(new RandomAccessReadBufferedFile(file));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
                }
                return otf;
            }
            catch (IOException e) {
                LOG.warn((Object)("Could not load font file: " + file), (Throwable)e);
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Type1Font getType1Font(String postScriptName, File file) {
            try (FileInputStream input = new FileInputStream(file);){
                Type1Font type1 = Type1Font.createWithPFB(input);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Loaded " + postScriptName + " from " + file));
                }
                Type1Font type1Font = type1;
                return type1Font;
            }
            catch (IOException e) {
                LOG.warn((Object)("Could not load font file: " + file), (Throwable)e);
                return null;
            }
        }
    }
}

