/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font;

import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dromara.pdf.shade.org.apache.fontbox.FontBoxFont;
import org.dromara.pdf.shade.org.apache.fontbox.cff.CFFFont;
import org.dromara.pdf.shade.org.apache.fontbox.cff.Type2CharString;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.CmapSubtable;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.CmapTable;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.GlyphData;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.GlyphTable;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.OTFParser;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.OpenTypeFont;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.PostScriptTable;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.TTFParser;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.TrueTypeFont;
import org.dromara.pdf.shade.org.apache.fontbox.util.BoundingBox;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.io.IOUtils;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessRead;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessReadBuffer;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessReadBufferedFile;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDDocument;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.common.PDStream;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.FontMappers;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.FontMapping;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.PDTrueTypeFontEmbedder;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.PDVectorFont;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.Standard14Fonts;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.UniUtil;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.encoding.BuiltInEncoding;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.encoding.Encoding;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.encoding.GlyphList;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.encoding.MacOSRomanEncoding;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.encoding.MacRomanEncoding;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.encoding.StandardEncoding;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.encoding.Type1Encoding;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.encoding.WinAnsiEncoding;

public class PDTrueTypeFont
extends PDSimpleFont
implements PDVectorFont {
    private static final Log LOG = LogFactory.getLog(PDTrueTypeFont.class);
    private static final int START_RANGE_F000 = 61440;
    private static final int START_RANGE_F100 = 61696;
    private static final int START_RANGE_F200 = 61952;
    private static final Map<String, Integer> INVERTED_MACOS_ROMAN = new HashMap<String, Integer>(250);
    private final TrueTypeFont ttf;
    private final OpenTypeFont otf;
    private final boolean isEmbedded;
    private final boolean isDamaged;
    private CmapSubtable cmapWinUnicode = null;
    private CmapSubtable cmapWinSymbol = null;
    private CmapSubtable cmapMacRoman = null;
    private boolean cmapInitialized = false;
    private final Map<Integer, Integer> gidToCode = new HashMap<Integer, Integer>();
    private BoundingBox fontBBox;

    public PDTrueTypeFont(COSDictionary fontDictionary) throws IOException {
        super(fontDictionary);
        PDFontDescriptor fd;
        PDStream ff2Stream;
        TrueTypeFont ttfFont = null;
        boolean fontIsDamaged = false;
        if (this.getFontDescriptor() != null && (ff2Stream = (fd = super.getFontDescriptor()).getFontFile2()) != null) {
            RandomAccessRead view = null;
            try {
                view = ff2Stream.getCOSObject().createView();
                TTFParser ttfParser = this.getParser(view, true);
                ttfFont = ttfParser.parse(view);
                ttfFont.close();
            }
            catch (IOException e) {
                LOG.warn((Object)("Could not read embedded TTF for font " + this.getBaseFont()), (Throwable)e);
                fontIsDamaged = true;
                IOUtils.closeQuietly(view);
            }
        }
        this.isEmbedded = ttfFont != null;
        this.isDamaged = fontIsDamaged;
        if (ttfFont == null) {
            FontMapping<TrueTypeFont> mapping = FontMappers.instance().getTrueTypeFont(this.getBaseFont(), this.getFontDescriptor());
            ttfFont = mapping.getFont();
            if (mapping.isFallback()) {
                LOG.warn((Object)("Using fallback font " + ttfFont + " for " + this.getBaseFont()));
            }
        }
        this.otf = ttfFont instanceof OpenTypeFont && ((OpenTypeFont)ttfFont).isSupportedOTF() ? (OpenTypeFont)ttfFont : null;
        this.ttf = ttfFont;
        this.readEncoding();
    }

    private PDTrueTypeFont(PDDocument document, TrueTypeFont ttf, Encoding encoding, boolean closeTTF) throws IOException {
        PDTrueTypeFontEmbedder embedder = new PDTrueTypeFontEmbedder(document, this.dict, ttf, encoding);
        this.encoding = encoding;
        this.ttf = ttf;
        this.otf = null;
        this.setFontDescriptor(embedder.getFontDescriptor());
        this.isEmbedded = true;
        this.isDamaged = false;
        this.glyphList = GlyphList.getAdobeGlyphList();
        if (closeTTF) {
            ttf.close();
        }
    }

    public static PDTrueTypeFont load(PDDocument doc, File file, Encoding encoding) throws IOException {
        return PDTrueTypeFont.load(doc, new RandomAccessReadBufferedFile(file), encoding);
    }

    public static PDTrueTypeFont load(PDDocument doc, InputStream input, Encoding encoding) throws IOException {
        return PDTrueTypeFont.load(doc, RandomAccessReadBuffer.createBufferFromStream(input), encoding);
    }

    public static PDTrueTypeFont load(PDDocument doc, TrueTypeFont ttf, Encoding encoding) throws IOException {
        return new PDTrueTypeFont(doc, ttf, encoding, false);
    }

    public static PDTrueTypeFont load(PDDocument doc, RandomAccessRead randomAccessRead, Encoding encoding) throws IOException {
        return new PDTrueTypeFont(doc, new TTFParser().parse(randomAccessRead), encoding, true);
    }

    public final String getBaseFont() {
        return this.dict.getNameAsString(COSName.BASE_FONT);
    }

    @Override
    protected Encoding readEncodingFromFont() throws IOException {
        if (!this.isEmbedded() && this.getStandard14AFM() != null) {
            return new Type1Encoding(this.getStandard14AFM());
        }
        if (this.getSymbolicFlag() != null && !this.getSymbolicFlag().booleanValue()) {
            return StandardEncoding.INSTANCE;
        }
        Standard14Fonts.FontName standard14Name = Standard14Fonts.getMappedFontName(this.getName());
        if (this.isStandard14() && standard14Name != Standard14Fonts.FontName.SYMBOL && standard14Name != Standard14Fonts.FontName.ZAPF_DINGBATS) {
            return StandardEncoding.INSTANCE;
        }
        PostScriptTable post = this.ttf.getPostScript();
        HashMap<Integer, String> codeToName = new HashMap<Integer, String>();
        for (int code = 0; code <= 256; ++code) {
            int gid = this.codeToGID(code);
            if (gid <= 0) continue;
            String name = null;
            if (post != null) {
                name = post.getName(gid);
            }
            if (name == null) {
                name = Integer.toString(gid);
            }
            codeToName.put(code, name);
        }
        return new BuiltInEncoding(codeToName);
    }

    @Override
    public int readCode(InputStream in) throws IOException {
        return in.read();
    }

    @Override
    public String getName() {
        return this.getBaseFont();
    }

    @Override
    public BoundingBox getBoundingBox() throws IOException {
        if (this.fontBBox == null) {
            this.fontBBox = this.generateBoundingBox();
        }
        return this.fontBBox;
    }

    private BoundingBox generateBoundingBox() throws IOException {
        PDRectangle bbox;
        if (this.getFontDescriptor() != null && (bbox = this.getFontDescriptor().getFontBoundingBox()) != null) {
            return new BoundingBox(bbox.getLowerLeftX(), bbox.getLowerLeftY(), bbox.getUpperRightX(), bbox.getUpperRightY());
        }
        return this.ttf.getFontBBox();
    }

    @Override
    public boolean isDamaged() {
        return this.isDamaged;
    }

    public TrueTypeFont getTrueTypeFont() {
        return this.ttf;
    }

    @Override
    public float getWidthFromFont(int code) throws IOException {
        int gid = this.codeToGID(code);
        float width = this.ttf.getAdvanceWidth(gid);
        float unitsPerEM = this.ttf.getUnitsPerEm();
        if (Float.compare(unitsPerEM, 1000.0f) != 0) {
            width *= 1000.0f / unitsPerEM;
        }
        return width;
    }

    @Override
    public float getHeight(int code) throws IOException {
        int gid = this.codeToGID(code);
        GlyphData glyph = this.ttf.getGlyph().getGlyph(gid);
        if (glyph != null) {
            return glyph.getBoundingBox().getHeight();
        }
        return 0.0f;
    }

    @Override
    protected byte[] encode(int unicode) throws IOException {
        if (this.encoding != null) {
            String uniName;
            if (!this.encoding.contains(this.getGlyphList().codePointToName(unicode))) {
                throw new IllegalArgumentException(String.format("U+%04X is not available in font %s encoding: %s", unicode, this.getName(), this.encoding.getEncodingName()));
            }
            String name = this.getGlyphList().codePointToName(unicode);
            Map<String, Integer> inverted = this.encoding.getNameToCodeMap();
            if (!this.ttf.hasGlyph(name) && !this.ttf.hasGlyph(uniName = UniUtil.getUniNameOfCodePoint(unicode))) {
                throw new IllegalArgumentException(String.format("No glyph for U+%04X in font %s", unicode, this.getName()));
            }
            int code = inverted.get(name);
            return new byte[]{(byte)code};
        }
        String name = this.getGlyphList().codePointToName(unicode);
        if (!this.ttf.hasGlyph(name)) {
            throw new IllegalArgumentException(String.format("No glyph for U+%04X in font %s", unicode, this.getName()));
        }
        int gid = this.ttf.nameToGID(name);
        Integer code = this.getGIDToCode().get(gid);
        if (code == null) {
            throw new IllegalArgumentException(String.format("U+%04X is not available in font %s encoding", unicode, this.getName()));
        }
        return new byte[]{(byte)code.intValue()};
    }

    protected Map<Integer, Integer> getGIDToCode() throws IOException {
        if (!this.gidToCode.isEmpty()) {
            return this.gidToCode;
        }
        for (int code = 0; code <= 255; ++code) {
            int gid = this.codeToGID(code);
            this.gidToCode.putIfAbsent(gid, code);
        }
        return this.gidToCode;
    }

    @Override
    public boolean isEmbedded() {
        return this.isEmbedded;
    }

    @Override
    public GeneralPath getPath(int code) throws IOException {
        if (this.otf != null && this.otf.isPostScript()) {
            GeneralPath path = this.getPathFromOutlines(code);
            return path == null ? new GeneralPath() : path;
        }
        int gid = this.codeToGID(code);
        GlyphTable glyphTable = this.ttf.getGlyph();
        if (glyphTable == null) {
            throw new IOException("glyf table is missing in font " + this.getName() + ", please report this file");
        }
        GlyphData glyph = glyphTable.getGlyph(gid);
        if (glyph == null) {
            return new GeneralPath();
        }
        return glyph.getPath();
    }

    @Override
    public GeneralPath getPath(String name) throws IOException {
        int gid = this.ttf.nameToGID(name);
        if (gid == 0) {
            try {
                gid = Integer.parseInt(name);
                if (gid > this.ttf.getNumberOfGlyphs()) {
                    gid = 0;
                }
            }
            catch (NumberFormatException e) {
                gid = 0;
            }
        }
        if (gid == 0) {
            return new GeneralPath();
        }
        GlyphData glyph = this.ttf.getGlyph().getGlyph(gid);
        if (glyph != null) {
            return glyph.getPath();
        }
        return new GeneralPath();
    }

    @Override
    public GeneralPath getNormalizedPath(int code) throws IOException {
        GeneralPath path = null;
        if (this.otf != null && this.otf.isPostScript()) {
            path = this.getPathFromOutlines(code);
        } else {
            int gid = this.codeToGID(code);
            path = this.getPath(code);
            if (gid == 0 && !this.isEmbedded() && !this.isStandard14()) {
                path = null;
            }
        }
        if (path == null) {
            return new GeneralPath();
        }
        if (this.ttf.getUnitsPerEm() != 1000) {
            float scale = 1000.0f / (float)this.ttf.getUnitsPerEm();
            path.transform(AffineTransform.getScaleInstance(scale, scale));
        }
        return path;
    }

    private GeneralPath getPathFromOutlines(int code) throws IOException {
        CFFFont cffFont = this.otf.getCFF().getFont();
        String name = this.getEncoding().getName(code);
        int sid = cffFont.getCharset().getSID(name);
        int gid = cffFont.getCharset().getGIDForSID(sid);
        Type2CharString type2CharString = cffFont.getType2CharString(gid);
        return type2CharString != null ? type2CharString.getPath() : null;
    }

    @Override
    public boolean hasGlyph(String name) throws IOException {
        int gid = this.ttf.nameToGID(name);
        return gid != 0 && gid < this.ttf.getMaximumProfile().getNumGlyphs();
    }

    @Override
    public FontBoxFont getFontBoxFont() {
        return this.ttf;
    }

    @Override
    public boolean hasGlyph(int code) throws IOException {
        return this.codeToGID(code) != 0;
    }

    public int codeToGID(int code) throws IOException {
        this.extractCmapTable();
        int gid = 0;
        if (!this.isSymbolic()) {
            Integer macCode;
            String unicode;
            String name = this.encoding.getName(code);
            if (".notdef".equals(name)) {
                return 0;
            }
            if (this.cmapWinUnicode != null && (unicode = GlyphList.getAdobeGlyphList().toUnicode(name)) != null) {
                int uni = unicode.codePointAt(0);
                gid = this.cmapWinUnicode.getGlyphId(uni);
            }
            if (gid == 0 && this.cmapMacRoman != null && (macCode = INVERTED_MACOS_ROMAN.get(name)) != null) {
                gid = this.cmapMacRoman.getGlyphId(macCode);
            }
            if (gid == 0) {
                gid = this.ttf.nameToGID(name);
            }
        } else {
            if (this.cmapWinUnicode != null) {
                if (this.encoding instanceof WinAnsiEncoding || this.encoding instanceof MacRomanEncoding) {
                    String name = this.encoding.getName(code);
                    if (".notdef".equals(name)) {
                        return 0;
                    }
                    String unicode = GlyphList.getAdobeGlyphList().toUnicode(name);
                    if (unicode != null) {
                        int uni = unicode.codePointAt(0);
                        gid = this.cmapWinUnicode.getGlyphId(uni);
                    }
                } else {
                    gid = this.cmapWinUnicode.getGlyphId(code);
                }
            }
            if (gid == 0 && this.cmapWinSymbol != null) {
                gid = this.cmapWinSymbol.getGlyphId(code);
                if (code >= 0 && code <= 255) {
                    if (gid == 0) {
                        gid = this.cmapWinSymbol.getGlyphId(code + 61440);
                    }
                    if (gid == 0) {
                        gid = this.cmapWinSymbol.getGlyphId(code + 61696);
                    }
                    if (gid == 0) {
                        gid = this.cmapWinSymbol.getGlyphId(code + 61952);
                    }
                }
            }
            if (gid == 0 && this.cmapMacRoman != null) {
                gid = this.cmapMacRoman.getGlyphId(code);
            }
        }
        return gid;
    }

    private void extractCmapTable() throws IOException {
        if (this.cmapInitialized) {
            return;
        }
        CmapTable cmapTable = this.ttf.getCmap();
        if (cmapTable != null) {
            CmapSubtable[] cmaps;
            for (CmapSubtable cmap : cmaps = cmapTable.getCmaps()) {
                if (3 == cmap.getPlatformId()) {
                    if (1 == cmap.getPlatformEncodingId()) {
                        this.cmapWinUnicode = cmap;
                        continue;
                    }
                    if (0 != cmap.getPlatformEncodingId()) continue;
                    this.cmapWinSymbol = cmap;
                    continue;
                }
                if (1 == cmap.getPlatformId() && 0 == cmap.getPlatformEncodingId()) {
                    this.cmapMacRoman = cmap;
                    continue;
                }
                if (0 == cmap.getPlatformId() && 0 == cmap.getPlatformEncodingId()) {
                    this.cmapWinUnicode = cmap;
                    continue;
                }
                if (0 != cmap.getPlatformId() || 3 != cmap.getPlatformEncodingId()) continue;
                this.cmapWinUnicode = cmap;
            }
        }
        this.cmapInitialized = true;
    }

    private TTFParser getParser(RandomAccessRead randomAccessRead, boolean isEmbedded) throws IOException {
        int amountRead;
        long startPos = randomAccessRead.getPosition();
        byte[] tagBytes = new byte[4];
        int remainingBytes = tagBytes.length;
        while ((amountRead = randomAccessRead.read(tagBytes, tagBytes.length - remainingBytes, remainingBytes)) > 0) {
            remainingBytes -= amountRead;
        }
        randomAccessRead.seek(startPos);
        if ("OTTO".equals(new String(tagBytes, StandardCharsets.US_ASCII))) {
            return new OTFParser(isEmbedded);
        }
        return new TTFParser(isEmbedded);
    }

    static {
        MacOSRomanEncoding.INSTANCE.getCodeToNameMap().forEach((key, value) -> INVERTED_MACOS_ROMAN.putIfAbsent((String)value, (Integer)key));
    }
}

