/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color;

import java.awt.color.ICC_Profile;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSStream;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDDocument;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.common.PDStream;

public final class PDOutputIntent
implements COSObjectable {
    private final COSDictionary dictionary;

    public PDOutputIntent(PDDocument doc, InputStream colorProfile) throws IOException {
        this.dictionary = new COSDictionary();
        this.dictionary.setItem(COSName.TYPE, (COSBase)COSName.OUTPUT_INTENT);
        this.dictionary.setItem(COSName.S, (COSBase)COSName.GTS_PDFA1);
        PDStream destOutputIntent = this.configureOutputProfile(doc, colorProfile);
        this.dictionary.setItem(COSName.DEST_OUTPUT_PROFILE, (COSObjectable)destOutputIntent);
    }

    public PDOutputIntent(COSDictionary dictionary) {
        this.dictionary = dictionary;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.dictionary;
    }

    public COSStream getDestOutputIntent() {
        return this.dictionary.getCOSStream(COSName.DEST_OUTPUT_PROFILE);
    }

    public String getInfo() {
        return this.dictionary.getString(COSName.INFO);
    }

    public void setInfo(String value) {
        this.dictionary.setString(COSName.INFO, value);
    }

    public String getOutputCondition() {
        return this.dictionary.getString(COSName.OUTPUT_CONDITION);
    }

    public void setOutputCondition(String value) {
        this.dictionary.setString(COSName.OUTPUT_CONDITION, value);
    }

    public String getOutputConditionIdentifier() {
        return this.dictionary.getString(COSName.OUTPUT_CONDITION_IDENTIFIER);
    }

    public void setOutputConditionIdentifier(String value) {
        this.dictionary.setString(COSName.OUTPUT_CONDITION_IDENTIFIER, value);
    }

    public String getRegistryName() {
        return this.dictionary.getString(COSName.REGISTRY_NAME);
    }

    public void setRegistryName(String value) {
        this.dictionary.setString(COSName.REGISTRY_NAME, value);
    }

    private PDStream configureOutputProfile(PDDocument doc, InputStream colorProfile) throws IOException {
        ICC_Profile icc = ICC_Profile.getInstance(colorProfile);
        PDStream stream = new PDStream(doc, (InputStream)new ByteArrayInputStream(icc.getData()), COSName.FLATE_DECODE);
        stream.getCOSObject().setInt(COSName.N, icc.getNumComponents());
        return stream;
    }
}

