/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.image;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSArray;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSInteger;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDDocument;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDDeviceCMYK;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDDeviceColorSpace;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public final class JPEGFactory {
    private JPEGFactory() {
    }

    public static PDImageXObject createFromStream(PDDocument document, InputStream stream) throws IOException {
        return JPEGFactory.createFromByteArray(document, org.dromara.pdf.shade.org.apache.pdfbox.io.IOUtils.toByteArray(stream));
    }

    public static PDImageXObject createFromByteArray(PDDocument document, byte[] byteArray) throws IOException {
        PDDeviceColorSpace colorSpace;
        ByteArrayInputStream byteStream = new ByteArrayInputStream(byteArray);
        JpegInfo meta = JpegImageParser.getImageInfo(byteStream);
        byteStream.reset();
        switch (meta.numComponents) {
            case 1: {
                colorSpace = PDDeviceGray.INSTANCE;
                break;
            }
            case 3: {
                colorSpace = PDDeviceRGB.INSTANCE;
                break;
            }
            case 4: {
                colorSpace = PDDeviceCMYK.INSTANCE;
                break;
            }
            default: {
                throw new UnsupportedOperationException("number of data elements not supported: " + meta.numComponents);
            }
        }
        PDImageXObject pdImage = new PDImageXObject(document, byteStream, COSName.DCT_DECODE, meta.width, meta.height, 8, colorSpace);
        if (colorSpace instanceof PDDeviceCMYK) {
            COSArray decode = new COSArray();
            decode.add(COSInteger.ONE);
            decode.add(COSInteger.ZERO);
            decode.add(COSInteger.ONE);
            decode.add(COSInteger.ZERO);
            decode.add(COSInteger.ONE);
            decode.add(COSInteger.ZERO);
            decode.add(COSInteger.ONE);
            decode.add(COSInteger.ZERO);
            pdImage.setDecode(decode);
        }
        return pdImage;
    }

    public static class JpegInfo {
        public final int width;
        public final int height;
        public final int numComponents;
        public final int precision;

        public JpegInfo(byte[] segmentData) {
            ByteArrayInputStream is = new ByteArrayInputStream(segmentData);
            this.precision = JpegInfo.readByte(is);
            this.height = JpegInfo.read2Bytes(is);
            this.width = JpegInfo.read2Bytes(is);
            this.numComponents = JpegInfo.readByte(is);
            if (this.numComponents < 0) {
                throw new IOException("Not a Valid JPEG File");
            }
            is.close();
        }

        public static byte readByte(InputStream in) throws IOException {
            int result = in.read();
            if (result < 0) {
                throw new IOException("Not a Valid JPEG File");
            }
            return (byte)(0xFF & result);
        }

        public static int read2Bytes(InputStream in) throws IOException {
            int byte1;
            int byte0 = in.read();
            if ((byte0 | (byte1 = in.read())) < 0) {
                throw new IOException("Not a Valid JPEG File");
            }
            return byte0 << 8 | byte1;
        }

        @Generated
        public int getWidth() {
            return this.width;
        }

        @Generated
        public int getHeight() {
            return this.height;
        }

        @Generated
        public int getNumComponents() {
            return this.numComponents;
        }

        @Generated
        public int getPrecision() {
            return this.precision;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JpegInfo)) {
                return false;
            }
            JpegInfo other = (JpegInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWidth() != other.getWidth()) {
                return false;
            }
            if (this.getHeight() != other.getHeight()) {
                return false;
            }
            if (this.getNumComponents() != other.getNumComponents()) {
                return false;
            }
            return this.getPrecision() == other.getPrecision();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JpegInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWidth();
            result = result * 59 + this.getHeight();
            result = result * 59 + this.getNumComponents();
            result = result * 59 + this.getPrecision();
            return result;
        }

        @Generated
        public String toString() {
            return "JPEGFactory.JpegInfo(width=" + this.getWidth() + ", height=" + this.getHeight() + ", numComponents=" + this.getNumComponents() + ", precision=" + this.getPrecision() + ")";
        }
    }

    public static class JpegImageParser {
        public static final byte[] SOI = new byte[]{-1, -40};
        public static final int SOF0_MARKER = 65472;
        public static final int EOI_MARKER = 65497;
        public static final int SOS_MARKER = 65498;

        public static JpegInfo getImageInfo(InputStream inputStream) throws IOException {
            JpegInfo info = JpegImageParser.readSegments(inputStream, new int[]{65472});
            if (info == null) {
                throw new IllegalStateException("No SOFN Data Found.");
            }
            return info;
        }

        public static JpegInfo readSegments(InputStream inputStream, int[] markers) throws IOException {
            return JpegImageParser.process(inputStream, new Visitor(markers));
        }

        public static JpegInfo process(InputStream is, Visitor visitor) throws IOException {
            int segmentLength;
            byte[] segmentData;
            int marker;
            JpegImageParser.readAndVerifyBytes(is, SOI);
            do {
                byte[] markerBytes;
                markerBytes = new byte[]{markerBytes[1], JpegImageParser.readByte(is, "Could not read marker")};
                while ((0xFF & markerBytes[0]) != 255 || (0xFF & markerBytes[1]) == 255) {
                }
                marker = (0xFF & markerBytes[0]) << 8 | 0xFF & markerBytes[1];
                if (marker == 65497 || marker == 65498) break;
                segmentLength = JpegImageParser.toUInt16(JpegImageParser.readBytes(is, 2));
                if (segmentLength >= 2) continue;
                throw new IOException("Invalid segment size");
            } while (visitor.visitSegment(marker, segmentData = JpegImageParser.readBytes(is, segmentLength - 2)));
            return visitor.getResult();
        }

        public static void readAndVerifyBytes(InputStream in, byte[] expected) throws IOException {
            for (byte element : expected) {
                int data = in.read();
                byte b = (byte)(0xFF & data);
                if (data < 0) {
                    throw new IOException("Unexpected EOF.");
                }
                if (b == element) continue;
                throw new IOException("Not a Valid JPEG File: doesn't begin with 0xffd8");
            }
        }

        public static byte readByte(InputStream in, String exceptionMessage) throws IOException {
            int result = in.read();
            if (result < 0) {
                throw new IOException(exceptionMessage);
            }
            return (byte)(0xFF & result);
        }

        public static byte[] readBytes(InputStream in, int length) throws IOException {
            return IOUtils.toByteArray((InputStream)in, (int)length);
        }

        public static int toUInt16(byte[] bytes) {
            int byte0 = 0xFF & bytes[0];
            int byte1 = 0xFF & bytes[1];
            return byte0 << 8 | byte1;
        }

        public static class Visitor {
            private final int[] sofnSegments = new int[]{65472};
            private final int[] markers;
            private JpegInfo result = null;

            public Visitor(int[] markers) {
                this.markers = markers;
            }

            public boolean visitSegment(int marker, byte[] segmentData) {
                if (marker == 65497) {
                    return false;
                }
                if (!this.keepMarker(marker, this.markers)) {
                    return true;
                }
                if (Arrays.binarySearch(this.sofnSegments, marker) >= 0) {
                    this.result = new JpegInfo(segmentData);
                }
                return true;
            }

            private boolean keepMarker(int marker, int[] markers) {
                for (int i : markers) {
                    if (marker != i) continue;
                    return true;
                }
                return false;
            }

            @Generated
            public JpegInfo getResult() {
                return this.result;
            }
        }
    }
}

