/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.shading.PDMeshBasedShadingType;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.shading.Patch;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.shading.TriangleBasedShadingContext;
import org.dromara.pdf.shade.org.apache.pdfbox.util.Matrix;

abstract class PatchMeshesShadingContext
extends TriangleBasedShadingContext {
    private List<Patch> patchList;

    protected PatchMeshesShadingContext(PDMeshBasedShadingType shading, ColorModel colorModel, AffineTransform xform, Matrix matrix, Rectangle deviceBounds, int controlPoints) throws IOException {
        super(shading, colorModel, xform, matrix);
        this.patchList = shading.collectPatches(xform, matrix, controlPoints);
        this.createPixelTable(deviceBounds);
    }

    @Override
    protected Map<Point, Integer> calcPixelTable(Rectangle deviceBounds) throws IOException {
        return Collections.emptyMap();
    }

    @Override
    protected int[][] calcPixelTableArray(Rectangle deviceBounds) throws IOException {
        int[][] array = new int[deviceBounds.width + 1][deviceBounds.height + 1];
        int initialValue = this.getBackground() != null ? this.getRgbBackground() : -1;
        for (int i = 0; i < deviceBounds.width + 1; ++i) {
            Arrays.fill(array[i], initialValue);
        }
        for (Patch it : this.patchList) {
            this.calcPixelTable(it.listOfTriangles, array, deviceBounds);
        }
        return array;
    }

    @Override
    public void dispose() {
        this.patchList = null;
        super.dispose();
    }

    @Override
    protected boolean isDataEmpty() {
        return this.patchList.isEmpty();
    }
}

