/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.shading.Line;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.shading.ShadedTriangle;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.shading.ShadingContext;
import org.dromara.pdf.shade.org.apache.pdfbox.util.Matrix;

abstract class TriangleBasedShadingContext
extends ShadingContext {
    private int[][] pixelTableArray;
    private int xOffset = 0;
    private int yOffset = 0;

    TriangleBasedShadingContext(PDShading shading, ColorModel cm, AffineTransform xform, Matrix matrix) throws IOException {
        super(shading, cm, xform, matrix);
    }

    protected final void createPixelTable(Rectangle deviceBounds) throws IOException {
        this.xOffset = -deviceBounds.x;
        this.yOffset = -deviceBounds.y;
        this.pixelTableArray = this.calcPixelTableArray(deviceBounds);
    }

    @Deprecated
    abstract Map<Point, Integer> calcPixelTable(Rectangle var1) throws IOException;

    abstract int[][] calcPixelTableArray(Rectangle var1) throws IOException;

    @Deprecated
    protected void calcPixelTable(List<ShadedTriangle> triangleList, Map<Point, Integer> map, Rectangle deviceBounds) throws IOException {
    }

    protected int[][] calcPixelTable(List<ShadedTriangle> triangleList, int[][] array, Rectangle deviceBounds) throws IOException {
        for (ShadedTriangle tri : triangleList) {
            int degree = tri.getDeg();
            if (degree == 2) {
                this.addLinePoints(tri.getLine(), array);
                continue;
            }
            int[] boundary = tri.getBoundary();
            boundary[0] = Math.max(boundary[0], deviceBounds.x);
            boundary[1] = Math.min(boundary[1], deviceBounds.x + deviceBounds.width);
            boundary[2] = Math.max(boundary[2], deviceBounds.y);
            boundary[3] = Math.min(boundary[3], deviceBounds.y + deviceBounds.height);
            for (int x = boundary[0]; x <= boundary[1]; ++x) {
                for (int y = boundary[2]; y <= boundary[3]; ++y) {
                    Point p = new Point(x, y);
                    if (!tri.contains(p)) continue;
                    this.addValueToArray(p, this.evalFunctionAndConvertToRGB(tri.calcColor(p)), array);
                }
            }
            Point p0 = new Point((int)Math.round(tri.corner[0].getX()), (int)Math.round(tri.corner[0].getY()));
            Point p1 = new Point((int)Math.round(tri.corner[1].getX()), (int)Math.round(tri.corner[1].getY()));
            Point p2 = new Point((int)Math.round(tri.corner[2].getX()), (int)Math.round(tri.corner[2].getY()));
            this.addLinePoints(new Line(p0, p1, tri.color[0], tri.color[1]), array);
            this.addLinePoints(new Line(p1, p2, tri.color[1], tri.color[2]), array);
            this.addLinePoints(new Line(p2, p0, tri.color[2], tri.color[0]), array);
        }
        return array;
    }

    private void addLinePoints(Line line, int[][] array) throws IOException {
        for (Point p : line.linePoints) {
            this.addValueToArray(p, this.evalFunctionAndConvertToRGB(line.calcColor(p)), array);
        }
    }

    private void addValueToArray(Point p, int value, int[][] array) {
        int xIndex = p.x + this.xOffset;
        int yIndex = p.y + this.yOffset;
        if (xIndex < 0 || yIndex < 0 || xIndex >= array.length || yIndex >= array[0].length) {
            return;
        }
        array[xIndex][yIndex] = value;
    }

    private int getValueFromArray(int x, int y) {
        int xIndex = x + this.xOffset;
        int yIndex = y + this.yOffset;
        if (xIndex < 0 || yIndex < 0 || xIndex >= this.pixelTableArray.length || yIndex >= this.pixelTableArray[0].length) {
            return -1;
        }
        return this.pixelTableArray[xIndex][yIndex];
    }

    private int evalFunctionAndConvertToRGB(float[] values) throws IOException {
        if (this.getShading().getFunction() != null) {
            values = this.getShading().evalFunction(values);
        }
        return this.convertToRGB(values);
    }

    abstract boolean isDataEmpty();

    @Override
    public final Raster getRaster(int x, int y, int w, int h) {
        WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
        int[] data = new int[w * h * 4];
        if (!this.isDataEmpty() || this.getBackground() != null) {
            for (int row = 0; row < h; ++row) {
                for (int col = 0; col < w; ++col) {
                    int value = this.getValueFromArray(x + col, y + row);
                    if (value < 0) continue;
                    int index = (row * w + col) * 4;
                    data[index] = value & 0xFF;
                    data[index + 1] = (value >>= 8) & 0xFF;
                    data[index + 2] = (value >>= 8) & 0xFF;
                    data[index + 3] = 255;
                }
            }
        }
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }
}

