/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.annotation;

import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSArray;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDDocument;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationMarkup;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.annotation.handlers.PDAppearanceHandler;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.annotation.handlers.PDPolylineAppearanceHandler;

public class PDAnnotationPolyline
extends PDAnnotationMarkup {
    public static final String SUB_TYPE = "PolyLine";
    private PDAppearanceHandler customAppearanceHandler;

    public PDAnnotationPolyline() {
        this.getCOSObject().setName(COSName.SUBTYPE, SUB_TYPE);
    }

    public PDAnnotationPolyline(COSDictionary dict) {
        super(dict);
    }

    public void setStartPointEndingStyle(String style) {
        String actualStyle = style == null ? "None" : style;
        COSArray array = this.getCOSObject().getCOSArray(COSName.LE);
        if (array == null || array.size() == 0) {
            array = new COSArray();
            array.add(COSName.getPDFName(actualStyle));
            array.add(COSName.getPDFName("None"));
            this.getCOSObject().setItem(COSName.LE, (COSBase)array);
        } else {
            array.setName(0, actualStyle);
        }
    }

    public String getStartPointEndingStyle() {
        COSArray array = this.getCOSObject().getCOSArray(COSName.LE);
        if (array != null && array.size() >= 2) {
            return array.getName(0, "None");
        }
        return "None";
    }

    public void setEndPointEndingStyle(String style) {
        String actualStyle = style == null ? "None" : style;
        COSArray array = this.getCOSObject().getCOSArray(COSName.LE);
        if (array == null || array.size() < 2) {
            array = new COSArray();
            array.add(COSName.getPDFName("None"));
            array.add(COSName.getPDFName(actualStyle));
            this.getCOSObject().setItem(COSName.LE, (COSBase)array);
        } else {
            array.setName(1, actualStyle);
        }
    }

    public String getEndPointEndingStyle() {
        COSArray array = this.getCOSObject().getCOSArray(COSName.LE);
        if (array != null && array.size() >= 2) {
            return array.getName(1, "None");
        }
        return "None";
    }

    public void setInteriorColor(PDColor ic) {
        this.getCOSObject().setItem(COSName.IC, (COSBase)ic.toCOSArray());
    }

    public PDColor getInteriorColor() {
        return this.getColor(COSName.IC);
    }

    public float[] getVertices() {
        COSArray vertices = this.getCOSObject().getCOSArray(COSName.VERTICES);
        return vertices != null ? vertices.toFloatArray() : null;
    }

    public void setVertices(float[] points) {
        COSArray ar = new COSArray();
        ar.setFloatArray(points);
        this.getCOSObject().setItem(COSName.VERTICES, (COSBase)ar);
    }

    public void setCustomAppearanceHandler(PDAppearanceHandler appearanceHandler) {
        this.customAppearanceHandler = appearanceHandler;
    }

    @Override
    public void constructAppearances() {
        this.constructAppearances(null);
    }

    @Override
    public void constructAppearances(PDDocument document) {
        if (this.customAppearanceHandler == null) {
            PDPolylineAppearanceHandler appearanceHandler = new PDPolylineAppearanceHandler(this, document);
            appearanceHandler.generateAppearanceStreams();
        } else {
            this.customAppearanceHandler.generateAppearanceStreams();
        }
    }
}

