/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.digitalsignature;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSArray;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSeedValueCertificate;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSeedValueMDP;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.digitalsignature.PDSeedValueTimeStamp;

public class PDSeedValue
implements COSObjectable {
    private static final List<String> allowedDigestNames = Arrays.asList(COSName.DIGEST_SHA1.getName(), COSName.DIGEST_SHA256.getName(), COSName.DIGEST_SHA384.getName(), COSName.DIGEST_SHA512.getName(), COSName.DIGEST_RIPEMD160.getName());
    public static final int FLAG_FILTER = 1;
    public static final int FLAG_SUBFILTER = 2;
    public static final int FLAG_V = 4;
    public static final int FLAG_REASON = 8;
    public static final int FLAG_LEGAL_ATTESTATION = 16;
    public static final int FLAG_ADD_REV_INFO = 32;
    public static final int FLAG_DIGEST_METHOD = 64;
    private final COSDictionary dictionary;

    public PDSeedValue() {
        this.dictionary = new COSDictionary();
        this.dictionary.setItem(COSName.TYPE, (COSBase)COSName.SV);
        this.dictionary.setDirect(true);
    }

    public PDSeedValue(COSDictionary dict) {
        this.dictionary = dict;
        this.dictionary.setDirect(true);
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.dictionary;
    }

    public boolean isFilterRequired() {
        return this.getCOSObject().getFlag(COSName.FF, 1);
    }

    public void setFilterRequired(boolean flag) {
        this.getCOSObject().setFlag(COSName.FF, 1, flag);
    }

    public boolean isSubFilterRequired() {
        return this.getCOSObject().getFlag(COSName.FF, 2);
    }

    public void setSubFilterRequired(boolean flag) {
        this.getCOSObject().setFlag(COSName.FF, 2, flag);
    }

    public boolean isDigestMethodRequired() {
        return this.getCOSObject().getFlag(COSName.FF, 64);
    }

    public void setDigestMethodRequired(boolean flag) {
        this.getCOSObject().setFlag(COSName.FF, 64, flag);
    }

    public boolean isVRequired() {
        return this.getCOSObject().getFlag(COSName.FF, 4);
    }

    public void setVRequired(boolean flag) {
        this.getCOSObject().setFlag(COSName.FF, 4, flag);
    }

    public boolean isReasonRequired() {
        return this.getCOSObject().getFlag(COSName.FF, 8);
    }

    public void setReasonRequired(boolean flag) {
        this.getCOSObject().setFlag(COSName.FF, 8, flag);
    }

    public boolean isLegalAttestationRequired() {
        return this.getCOSObject().getFlag(COSName.FF, 16);
    }

    public void setLegalAttestationRequired(boolean flag) {
        this.getCOSObject().setFlag(COSName.FF, 16, flag);
    }

    public boolean isAddRevInfoRequired() {
        return this.getCOSObject().getFlag(COSName.FF, 32);
    }

    public void setAddRevInfoRequired(boolean flag) {
        this.getCOSObject().setFlag(COSName.FF, 32, flag);
    }

    public String getFilter() {
        return this.dictionary.getNameAsString(COSName.FILTER);
    }

    public void setFilter(COSName filter) {
        this.dictionary.setItem(COSName.FILTER, (COSBase)filter);
    }

    public List<String> getSubFilter() {
        COSArray fields = this.dictionary.getCOSArray(COSName.SUB_FILTER);
        return fields != null ? fields.toCOSNameStringList() : Collections.emptyList();
    }

    public void setSubFilter(List<String> subfilter) {
        this.dictionary.setItem(COSName.SUB_FILTER, (COSBase)COSArray.ofCOSNames(subfilter));
    }

    public List<String> getDigestMethod() {
        COSArray fields = this.dictionary.getCOSArray(COSName.DIGEST_METHOD);
        return fields != null ? fields.toCOSNameStringList() : Collections.emptyList();
    }

    public void setDigestMethod(List<String> digestMethod) {
        for (String digestName : digestMethod) {
            if (allowedDigestNames.contains(digestName)) continue;
            throw new IllegalArgumentException("Specified digest " + digestName + " isn't allowed.");
        }
        this.dictionary.setItem(COSName.DIGEST_METHOD, (COSBase)COSArray.ofCOSNames(digestMethod));
    }

    public float getV() {
        return this.dictionary.getFloat(COSName.V);
    }

    public void setV(float minimumRequiredCapability) {
        this.dictionary.setFloat(COSName.V, minimumRequiredCapability);
    }

    public List<String> getReasons() {
        COSArray fields = this.dictionary.getCOSArray(COSName.REASONS);
        return fields != null ? fields.toCOSNameStringList() : Collections.emptyList();
    }

    public void setReasons(List<String> reasons) {
        this.dictionary.setItem(COSName.REASONS, (COSBase)COSArray.ofCOSStrings(reasons));
    }

    public PDSeedValueMDP getMDP() {
        COSDictionary dict = this.dictionary.getCOSDictionary(COSName.MDP);
        return dict != null ? new PDSeedValueMDP(dict) : null;
    }

    public void setMPD(PDSeedValueMDP mdp) {
        if (mdp != null) {
            this.dictionary.setItem(COSName.MDP, (COSBase)mdp.getCOSObject());
        }
    }

    public PDSeedValueCertificate getSeedValueCertificate() {
        COSDictionary certificate = this.dictionary.getCOSDictionary(COSName.CERT);
        return certificate != null ? new PDSeedValueCertificate(certificate) : null;
    }

    public void setSeedValueCertificate(PDSeedValueCertificate certificate) {
        this.dictionary.setItem(COSName.CERT, (COSObjectable)certificate);
    }

    public PDSeedValueTimeStamp getTimeStamp() {
        COSDictionary dict = this.dictionary.getCOSDictionary(COSName.TIME_STAMP);
        return dict != null ? new PDSeedValueTimeStamp(dict) : null;
    }

    public void setTimeStamp(PDSeedValueTimeStamp timestamp) {
        if (timestamp != null) {
            this.dictionary.setItem(COSName.TIME_STAMP, (COSBase)timestamp.getCOSObject());
        }
    }

    public List<String> getLegalAttestation() {
        COSArray fields = this.dictionary.getCOSArray(COSName.LEGAL_ATTESTATION);
        return fields != null ? fields.toCOSNameStringList() : Collections.emptyList();
    }

    public void setLegalAttestation(List<String> legalAttestation) {
        this.dictionary.setItem(COSName.LEGAL_ATTESTATION, (COSBase)COSArray.ofCOSStrings(legalAttestation));
    }
}

