/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.form;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSArray;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSInputStream;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSStream;
import org.dromara.pdf.shade.org.apache.pdfbox.io.IOUtils;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.dromara.pdf.shade.org.apache.pdfbox.util.XMLUtil;
import org.w3c.dom.Document;

public final class PDXFAResource
implements COSObjectable {
    private final COSBase xfa;

    public PDXFAResource(COSBase xfaBase) {
        this.xfa = xfaBase;
    }

    @Override
    public COSBase getCOSObject() {
        return this.xfa;
    }

    public byte[] getBytes() throws IOException {
        if (this.getCOSObject() instanceof COSArray) {
            return PDXFAResource.getBytesFromPacket((COSArray)this.getCOSObject());
        }
        if (this.xfa.getCOSObject() instanceof COSStream) {
            return PDXFAResource.getBytesFromStream((COSStream)this.getCOSObject());
        }
        return new byte[0];
    }

    private static byte[] getBytesFromPacket(COSArray cosArray) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            for (int i = 1; i < cosArray.size(); i += 2) {
                COSBase cosObj = cosArray.getObject(i);
                if (!(cosObj instanceof COSStream)) continue;
                baos.write(PDXFAResource.getBytesFromStream((COSStream)cosObj.getCOSObject()));
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }

    private static byte[] getBytesFromStream(COSStream stream) throws IOException {
        try (COSInputStream is = stream.createInputStream();){
            byte[] byArray = IOUtils.toByteArray(is);
            return byArray;
        }
    }

    public Document getDocument() throws IOException {
        return XMLUtil.parse(new ByteArrayInputStream(this.getBytes()), true);
    }
}

