/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.preflight;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDocument;
import org.dromara.pdf.shade.org.apache.pdfbox.io.RandomAccessRead;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDDocument;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.Format;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.PreflightConfiguration;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.PreflightContext;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.ValidationResult;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.exception.ValidationException;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.utils.ContextHelper;

public class PreflightDocument
extends PDDocument {
    private final ValidationResult result = new ValidationResult(true);
    private final PreflightConfiguration config;
    private PreflightContext context;
    private final Format specification;

    public PreflightDocument(COSDocument doc, Format format) {
        this(doc, format, null, null);
    }

    @Deprecated
    public PreflightDocument(COSDocument doc, Format format, PreflightConfiguration config) {
        this(doc, format, config, null);
    }

    public PreflightDocument(COSDocument doc, Format format, PreflightConfiguration config, RandomAccessRead source) {
        super(doc, source);
        this.specification = format;
        this.config = config == null ? PreflightConfiguration.createPdfA1BConfiguration() : config;
    }

    public List<ValidationResult.ValidationError> getValidationErrors() {
        return Collections.unmodifiableList(this.result.getErrorsList());
    }

    public void addValidationError(ValidationResult.ValidationError error) {
        if (error != null) {
            this.result.addError(error);
        }
    }

    public void addValidationErrors(List<ValidationResult.ValidationError> errorList) {
        if (errorList != null) {
            this.result.addErrors(errorList);
        }
    }

    public PreflightContext getContext() {
        return this.context;
    }

    public void setContext(PreflightContext context) {
        this.context = context;
    }

    public ValidationResult validate() throws ValidationException {
        this.context.setConfig(this.config);
        Collection<String> processes = this.config.getProcessNames();
        for (String name : processes) {
            ContextHelper.validateElement(this.context, name);
        }
        return this.result;
    }

    public Format getSpecification() {
        return this.specification;
    }
}

