/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.preflight.action;

import java.io.IOException;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSArray;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSNumber;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSString;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.PreflightContext;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.ValidationResult;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.action.ActionManagerFactory;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.action.GoToAction;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.exception.ValidationException;

public class GoToRemoteAction
extends GoToAction {
    public GoToRemoteAction(ActionManagerFactory amFact, COSDictionary adict, PreflightContext ctx, String aaKey) {
        super(amFact, adict, ctx, aaKey);
    }

    @Override
    protected boolean innerValid() throws ValidationException {
        COSBase dest = this.actionDictionary.getItem(COSName.D);
        if (dest == null) {
            this.context.addValidationError(new ValidationResult.ValidationError("6.1.1", "/D entry is mandatory for the GoToActions"));
            return false;
        }
        if (!(dest instanceof COSName || dest instanceof COSString || dest instanceof COSArray)) {
            this.context.addValidationError(new ValidationResult.ValidationError("6.1.3", "Type " + dest.getClass().getSimpleName() + " of /D entry is invalid"));
            return false;
        }
        COSBase f = this.actionDictionary.getItem(COSName.F);
        if (f == null) {
            this.context.addValidationError(new ValidationResult.ValidationError("6.1.1", "/F entry is mandatory for the GoToRemoteActions"));
            return false;
        }
        if (dest instanceof COSArray) {
            COSArray ar = (COSArray)dest;
            if (ar.size() < 2) {
                this.context.addValidationError(new ValidationResult.ValidationError("1.2.3", "Destination array must have at least 2 elements"));
                return false;
            }
            if (!(ar.get(1) instanceof COSName)) {
                this.context.addValidationError(new ValidationResult.ValidationError("1.2.3", "Second element of destination array must be a name"));
                return false;
            }
            this.validateExplicitDestination(ar);
        }
        try {
            PDDestination.create(dest);
        }
        catch (IOException e) {
            this.context.addValidationError(new ValidationResult.ValidationError("1.2.3", e.getMessage(), e));
            return false;
        }
        return true;
    }

    private boolean validateExplicitDestination(COSArray ar) {
        if (!(ar.get(0) instanceof COSNumber)) {
            this.context.addValidationError(new ValidationResult.ValidationError("6.1.3", "First element in /D array entry of GoToRemoteAction must be a page number, but is " + ar.get(0)));
            return false;
        }
        return true;
    }
}

