/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.preflight.font;

import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.PDSimpleFont;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.PreflightContext;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.ValidationResult;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.font.SimpleFontValidator;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.font.container.Type1Container;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.font.descriptor.Type1DescriptorHelper;

public class Type1FontValidator
extends SimpleFontValidator<Type1Container> {
    public Type1FontValidator(PreflightContext context, PDSimpleFont font) {
        super(context, font, font.getCOSObject(), new Type1Container(font));
    }

    @Override
    protected void createFontDescriptorHelper() {
        this.descriptorHelper = new Type1DescriptorHelper(this.context, (PDSimpleFont)this.font, (Type1Container)this.fontContainer);
    }

    @Override
    protected void checkEncoding() {
        COSBase encoding = this.fontDictionary.getDictionaryObject(COSName.ENCODING);
        if (encoding != null) {
            if (encoding instanceof COSName) {
                COSName encodingName = (COSName)encoding;
                if (!(encodingName.equals(COSName.MAC_ROMAN_ENCODING) || encodingName.equals(COSName.MAC_EXPERT_ENCODING) || encodingName.equals(COSName.WIN_ANSI_ENCODING) || encodingName.equals(COSName.PDF_DOC_ENCODING) || encodingName.equals(COSName.STANDARD_ENCODING))) {
                    ((Type1Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.5"));
                }
            } else if (!(encoding instanceof COSDictionary)) {
                ((Type1Container)this.fontContainer).push(new ValidationResult.ValidationError("3.1.5"));
            }
        }
    }
}

