/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.preflight.font.descriptor;

import java.io.IOException;
import org.dromara.pdf.shade.org.apache.fontbox.ttf.TrueTypeFont;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSStream;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.common.PDStream;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.PDFontDescriptor;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.PreflightContext;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.ValidationResult;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.font.container.TrueTypeContainer;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.font.descriptor.FontDescriptorHelper;

public class TrueTypeDescriptorHelper
extends FontDescriptorHelper<TrueTypeContainer> {
    private final PDTrueTypeFont pdTrueTypeFont;

    public TrueTypeDescriptorHelper(PreflightContext context, PDTrueTypeFont font, TrueTypeContainer fontContainer) {
        super(context, font, fontContainer);
        this.pdTrueTypeFont = font;
    }

    @Override
    public PDStream extractFontFile(PDFontDescriptor fontDescriptor) {
        COSStream stream;
        PDStream fontFile = fontDescriptor.getFontFile2();
        COSStream cOSStream = stream = fontFile == null ? null : fontFile.getCOSObject();
        if (stream == null) {
            ((TrueTypeContainer)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", fontDescriptor.getFontName() + ": The FontFile2 is missing"));
            ((TrueTypeContainer)this.fContainer).notEmbedded();
            return null;
        }
        if (stream.getInt(COSName.LENGTH1) <= 0) {
            ((TrueTypeContainer)this.fContainer).push(new ValidationResult.ValidationError("3.1.3", fontDescriptor.getFontName() + ": The FontFile entry /Length1 is invalid"));
            return null;
        }
        return fontFile;
    }

    @Override
    protected void processFontFile(PDFontDescriptor fontDescriptor, PDStream fontFile) {
        if (this.font.isDamaged()) {
            ((TrueTypeContainer)this.fContainer).push(new ValidationResult.ValidationError("3.2.2", this.font.getName() + ": The FontFile can't be read"));
        } else {
            TrueTypeFont ttf = this.pdTrueTypeFont.getTrueTypeFont();
            try {
                if (this.pdTrueTypeFont.isSymbolic() && ttf.getCmap().getCmaps().length != 1) {
                    ((TrueTypeContainer)this.fContainer).push(new ValidationResult.ValidationError("3.1.5", this.font.getName() + ": Symbolic TrueType font has more than one 'cmap' entry"));
                }
            }
            catch (IOException e) {
                ((TrueTypeContainer)this.fContainer).push(new ValidationResult.ValidationError("3.2.2", this.font.getName() + ": The TTF 'cmap' could not be read"));
            }
        }
    }
}

