/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.preflight.process;

import java.io.IOException;
import java.util.List;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.PreflightContext;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.ValidationResult;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.process.ValidationProcess;

public abstract class AbstractProcess
implements ValidationProcess {
    protected void addValidationError(PreflightContext ctx, ValidationResult.ValidationError error) {
        ctx.addValidationError(error);
    }

    protected void addValidationErrors(PreflightContext ctx, List<ValidationResult.ValidationError> errors) {
        errors.forEach(error -> this.addValidationError(ctx, (ValidationResult.ValidationError)error));
    }

    protected void addFontError(COSDictionary dictionary, PreflightContext context, IOException e) {
        COSName subType;
        COSName type = dictionary.getCOSName(COSName.TYPE, COSName.FONT);
        if (!COSName.FONT.equals(type)) {
            this.addValidationError(context, new ValidationResult.ValidationError("3.1.14", "Expected 'Font' dictionary but found '" + type.getName() + "'"));
        }
        String fontName = "Unknown";
        if (dictionary.containsKey(COSName.BASE_FONT)) {
            fontName = dictionary.getNameAsString(COSName.BASE_FONT);
        }
        if (COSName.TYPE1.equals(subType = dictionary.getCOSName(COSName.SUBTYPE))) {
            this.addValidationError(context, new ValidationResult.ValidationError("3.2.1", "The FontFile can't be read for " + fontName + ": " + e.getMessage()));
        } else if (COSName.MM_TYPE1.equals(subType)) {
            this.addValidationError(context, new ValidationResult.ValidationError("3.2.1", "The FontFile can't be read for " + fontName + ": " + e.getMessage()));
        } else if (COSName.TRUE_TYPE.equals(subType)) {
            this.addValidationError(context, new ValidationResult.ValidationError("3.2.2", "The FontFile can't be read for " + fontName + ": " + e.getMessage()));
        } else if (COSName.TYPE3.equals(subType)) {
            this.addValidationError(context, new ValidationResult.ValidationError("3.2.4", "The FontFile can't be read for " + fontName + ": " + e.getMessage()));
        } else if (COSName.TYPE0.equals(subType)) {
            this.addValidationError(context, new ValidationResult.ValidationError("3.2.3", "The FontFile can't be read for " + fontName + ": " + e.getMessage()));
        } else if (COSName.CID_FONT_TYPE0.equals(subType)) {
            this.addValidationError(context, new ValidationResult.ValidationError("3.1.14", "Unexpected CIDFontType0 descendant font for " + fontName + ": " + e.getMessage()));
        } else if (COSName.CID_FONT_TYPE2.equals(subType)) {
            this.addValidationError(context, new ValidationResult.ValidationError("3.1.14", "Unexpected CIDFontType2 descendant font for " + fontName + ": " + e.getMessage()));
        } else {
            this.addValidationError(context, new ValidationResult.ValidationError("3.1.14", "Unknown font type for " + fontName));
        }
    }
}

