/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.preflight.process;

import java.io.IOException;
import java.util.List;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSBase;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.action.PDFormFieldAdditionalActions;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationWidget;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.form.PDNonTerminalField;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.form.PDTerminalField;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.PreflightContext;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.ValidationResult;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.exception.ValidationException;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.process.AbstractProcess;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.utils.ContextHelper;

public class AcroFormValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext ctx) throws ValidationException {
        PDDocumentCatalog catalog = ctx.getDocument().getDocumentCatalog();
        if (catalog != null) {
            PDAcroForm acroForm = catalog.getAcroForm(null);
            if (acroForm != null) {
                this.checkNeedAppearences(ctx, acroForm);
                try {
                    this.exploreFields(ctx, acroForm.getFields());
                }
                catch (IOException e) {
                    throw new ValidationException("Unable to get the list of fields : " + e.getMessage(), e);
                }
            }
        } else {
            ctx.addValidationError(new ValidationResult.ValidationError("1.2.14", "There is no Catalog entry in the Document"));
        }
    }

    protected void checkNeedAppearences(PreflightContext ctx, PDAcroForm acroForm) {
        if (acroForm.getNeedAppearances()) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("1.2.3", "NeedAppearance is present with the value \"true\""));
        }
    }

    protected boolean exploreFields(PreflightContext ctx, List<PDField> fields) throws IOException {
        for (PDField field : fields) {
            if (this.validateField(ctx, field)) continue;
            return false;
        }
        return true;
    }

    protected boolean exploreWidgets(PreflightContext ctx, List<PDAnnotationWidget> widgets) throws IOException {
        for (PDAnnotationWidget widget : widgets) {
            ContextHelper.validateElement(ctx, widget.getCOSObject(), "annotations-process");
        }
        return true;
    }

    protected boolean validateField(PreflightContext ctx, PDField field) throws IOException {
        boolean res = true;
        PDFormFieldAdditionalActions aa = field.getActions();
        if (aa != null) {
            this.addValidationError(ctx, new ValidationResult.ValidationError("6.2.3", "\"AA\" must not be used in a Field dictionary"));
            res = false;
        }
        if (field instanceof PDTerminalField) {
            List<PDAnnotationWidget> widgets = field.getWidgets();
            if (res && widgets != null) {
                for (PDAnnotationWidget widget : widgets) {
                    ContextHelper.validateElement(ctx, widget.getCOSObject(), "annotations-process");
                    COSBase act = widget.getCOSObject().getDictionaryObject(COSName.A);
                    if (act == null) continue;
                    this.addValidationError(ctx, new ValidationResult.ValidationError("6.2.4", "\"A\" must not be used in a widget annotation"));
                    return false;
                }
            }
            return this.exploreWidgets(ctx, field.getWidgets());
        }
        return res && this.exploreFields(ctx, ((PDNonTerminalField)field).getChildren());
    }
}

