/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.preflight.process.reflect;

import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.PreflightConfiguration;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.PreflightContext;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.PreflightPath;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.ValidationResult;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.annotation.AnnotationValidator;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.annotation.AnnotationValidatorFactory;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.exception.ValidationException;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.process.AbstractProcess;

public class AnnotationValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext context) throws ValidationException {
        PreflightPath vPath = context.getValidationPath();
        if (vPath.isEmpty()) {
            return;
        }
        if (!vPath.isExpectedType(COSDictionary.class)) {
            context.addValidationError(new ValidationResult.ValidationError("5.3", "Annotation validation process needs at least one COSDictionary object"));
        } else {
            COSDictionary annotDict = (COSDictionary)vPath.peek();
            PreflightConfiguration config = context.getConfig();
            AnnotationValidatorFactory factory = config.getAnnotFact();
            AnnotationValidator annotValidator = factory.getAnnotationValidator(context, annotDict);
            if (annotValidator != null) {
                annotValidator.validate();
            }
        }
    }
}

