/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.preflight.process.reflect;

import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSStream;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.PDPostScriptXObject;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.PreflightContext;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.PreflightPath;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.ValidationResult;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.exception.ValidationException;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.process.AbstractProcess;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.xobject.AbstractXObjValidator;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.xobject.XObjFormValidator;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.xobject.XObjImageValidator;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.xobject.XObjPostscriptValidator;

public class GraphicObjectPageValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext context) throws ValidationException {
        PreflightPath vPath = context.getValidationPath();
        AbstractXObjValidator validator = null;
        if (!vPath.isEmpty() && vPath.isExpectedType(PDImageXObject.class)) {
            validator = new XObjImageValidator(context, (PDImageXObject)vPath.peek());
        } else if (!vPath.isEmpty() && vPath.isExpectedType(PDFormXObject.class)) {
            validator = new XObjFormValidator(context, (PDFormXObject)vPath.peek());
        } else if (!vPath.isEmpty() && vPath.isExpectedType(PDPostScriptXObject.class)) {
            validator = new XObjPostscriptValidator(context, (PDPostScriptXObject)vPath.peek());
        } else if (!vPath.isEmpty() && vPath.isExpectedType(COSStream.class)) {
            context.addValidationError(new ValidationResult.ValidationError("2.1.10", "Invalid XObject subtype"));
        } else {
            context.addValidationError(new ValidationResult.ValidationError("2.1.9", "Graphic validation process needs at least one PDXObject"));
        }
        if (validator != null) {
            validator.validate();
        }
    }
}

