/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.preflight.process.reflect;

import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSDictionary;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDPage;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDResources;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.PreflightContext;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.PreflightPath;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.ValidationResult;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.content.PreflightContentStream;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.exception.ValidationException;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.process.AbstractProcess;
import org.dromara.pdf.shade.org.apache.pdfbox.preflight.utils.ContextHelper;

public class TilingPatternValidationProcess
extends AbstractProcess {
    @Override
    public void validate(PreflightContext context) throws ValidationException {
        PreflightPath vPath = context.getValidationPath();
        if (vPath.isEmpty()) {
            return;
        }
        if (!vPath.isExpectedType(PDTilingPattern.class)) {
            context.addValidationError(new ValidationResult.ValidationError("2.1.9", "Tiling pattern validation required at least a PDPage"));
        } else {
            PDTilingPattern tilingPattern = (PDTilingPattern)vPath.peek();
            PDPage page = vPath.getClosestPathElement(PDPage.class);
            this.checkMandatoryFields(context, page, tilingPattern);
            this.parseResources(context, page, tilingPattern);
            this.parsePatternContent(context, page, tilingPattern);
        }
    }

    protected void parseResources(PreflightContext context, PDPage page, PDTilingPattern pattern) throws ValidationException {
        PDResources resources = pattern.getResources();
        if (resources != null) {
            ContextHelper.validateElement(context, resources, "resources-process");
        }
    }

    protected void parsePatternContent(PreflightContext context, PDPage page, PDTilingPattern pattern) throws ValidationException {
        PreflightContentStream csWrapper = new PreflightContentStream(context, page);
        csWrapper.validatePatternContentStream(pattern);
    }

    protected void checkMandatoryFields(PreflightContext context, PDPage page, PDTilingPattern pattern) {
        COSDictionary dictionary = pattern.getCOSObject();
        boolean res = dictionary.getItem(COSName.RESOURCES) != null;
        res = res && dictionary.getItem(COSName.BBOX) != null;
        res = res && dictionary.getItem(COSName.PAINT_TYPE) != null;
        res = res && dictionary.getItem(COSName.TILING_TYPE) != null;
        res = res && dictionary.getItem(COSName.X_STEP) != null;
        boolean bl = res = res && dictionary.getItem(COSName.Y_STEP) != null;
        if (!res) {
            context.addValidationError(new ValidationResult.ValidationError("2.4.6"));
        }
    }
}

