/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.dromara.pdf.shade.org.apache.pdfbox.Loader;
import org.dromara.pdf.shade.org.apache.pdfbox.pdfwriter.compress.CompressParameters;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDDocument;
import picocli.CommandLine;

@CommandLine.Command(name="DecompressObjectstreams", header={"Decompresses object streams in a PDF file."})
public final class DecompressObjectstreams
implements Callable<Integer> {
    private final PrintStream SYSERR = System.err;
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"display this help message"})
    boolean usageHelpRequested;
    @CommandLine.Option(names={"-i", "--input"}, description={"the PDF file to decompress"}, required=true)
    private File infile;
    @CommandLine.Option(names={"-o", "--output"}, description={"the decompressed PDF file. If omitted the original file is overwritten."})
    private File outfile;

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine((Object)new DecompressObjectstreams()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() {
        try (PDDocument doc = Loader.loadPDF(this.infile);){
            if (this.outfile == null) {
                this.outfile = this.infile;
            }
            doc.save(this.outfile, CompressParameters.NO_COMPRESSION);
        }
        catch (IOException ioe) {
            this.SYSERR.println("Error processing file [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
            return 4;
        }
        return 0;
    }
}

