/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.tools;

import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.commons.io.FilenameUtils;
import org.dromara.pdf.shade.org.apache.pdfbox.Loader;
import org.dromara.pdf.shade.org.apache.pdfbox.contentstream.PDFGraphicsStreamEngine;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSName;
import org.dromara.pdf.shade.org.apache.pdfbox.cos.COSStream;
import org.dromara.pdf.shade.org.apache.pdfbox.io.IOUtils;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDDocument;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDPage;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDResources;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.font.PDFont;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDDeviceGray;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.color.PDPattern;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.form.PDTransparencyGroup;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.pattern.PDAbstractPattern;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPattern;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.state.PDGraphicsState;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.state.PDSoftMask;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.dromara.pdf.shade.org.apache.pdfbox.tools.Version;
import org.dromara.pdf.shade.org.apache.pdfbox.tools.imageio.ImageIOUtil;
import org.dromara.pdf.shade.org.apache.pdfbox.util.Matrix;
import org.dromara.pdf.shade.org.apache.pdfbox.util.Vector;
import picocli.CommandLine;

@CommandLine.Command(name="extractimages", header={"Extracts the images from a PDF document"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public final class ExtractImages
implements Callable<Integer> {
    private final PrintStream SYSOUT;
    private final PrintStream SYSERR;
    private static final List<String> JPEG = Arrays.asList(COSName.DCT_DECODE.getName(), COSName.DCT_DECODE_ABBREVIATION.getName());
    @CommandLine.Option(names={"-password"}, description={"the password for the PDF or certificate in keystore."}, arity="0..1", interactive=true)
    private String password;
    @CommandLine.Option(names={"-prefix"}, description={"the image prefix (default to pdf name)."})
    private String prefix;
    @CommandLine.Option(names={"-useDirectJPEG"}, description={"Forces the direct extraction of JPEG/JPX images regardless of colorspace or masking."})
    private boolean useDirectJPEG;
    @CommandLine.Option(names={"-noColorConvert"}, description={"Images are extracted with their original colorspace if possible."})
    private boolean noColorConvert;
    @CommandLine.Option(names={"-i", "--input"}, description={"the PDF file"}, required=true)
    private File infile;
    private final Set<COSStream> seen = new HashSet<COSStream>();
    private int imageCounter = 1;

    public ExtractImages() {
        this.SYSOUT = System.out;
        this.SYSERR = System.err;
    }

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine((Object)new ExtractImages()).execute(args);
        System.exit(exitCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Integer call() {
        try (PDDocument document = Loader.loadPDF(this.infile, this.password);){
            AccessPermission ap = document.getCurrentAccessPermission();
            if (!ap.canExtractContent()) {
                this.SYSERR.println("You do not have permission to extract images");
                Integer n = 1;
                return n;
            }
            if (this.prefix == null) {
                this.prefix = FilenameUtils.removeExtension((String)this.infile.getAbsolutePath());
            }
            Iterator<PDPage> iterator = document.getPages().iterator();
            while (iterator.hasNext()) {
                PDPage page = iterator.next();
                ImageGraphicsEngine extractor = new ImageGraphicsEngine(page);
                extractor.run();
            }
            return 0;
        }
        catch (IOException ioe) {
            this.SYSERR.println("Error extracting images [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
            return 4;
        }
    }

    private class ImageGraphicsEngine
    extends PDFGraphicsStreamEngine {
        protected ImageGraphicsEngine(PDPage page) {
            super(page);
        }

        public void run() throws IOException {
            PDPage page = this.getPage();
            this.processPage(page);
            PDResources res = page.getResources();
            if (res == null) {
                return;
            }
            for (COSName name : res.getExtGStateNames()) {
                PDTransparencyGroup group;
                PDSoftMask softMask;
                PDExtendedGraphicsState extGState = res.getExtGState(name);
                if (extGState == null || (softMask = extGState.getSoftMask()) == null || (group = softMask.getGroup()) == null) continue;
                res.getExtGState(name).copyIntoGraphicsState(this.getGraphicsState());
                this.processSoftMask(group);
            }
        }

        @Override
        public void drawImage(PDImage pdImage) throws IOException {
            if (pdImage instanceof PDImageXObject) {
                if (pdImage.isStencil()) {
                    this.processColor(this.getGraphicsState().getNonStrokingColor());
                }
                PDImageXObject xobject = (PDImageXObject)pdImage;
                if (ExtractImages.this.seen.contains(xobject.getCOSObject())) {
                    return;
                }
                ExtractImages.this.seen.add(xobject.getCOSObject());
            }
            String name = ExtractImages.this.prefix + "-" + ExtractImages.this.imageCounter;
            ExtractImages.this.imageCounter++;
            this.write2file(pdImage, name, ExtractImages.this.useDirectJPEG, ExtractImages.this.noColorConvert);
        }

        @Override
        public void appendRectangle(Point2D p0, Point2D p1, Point2D p2, Point2D p3) throws IOException {
        }

        @Override
        public void clip(int windingRule) throws IOException {
        }

        @Override
        public void moveTo(float x, float y) throws IOException {
        }

        @Override
        public void lineTo(float x, float y) throws IOException {
        }

        @Override
        public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) throws IOException {
        }

        @Override
        public Point2D getCurrentPoint() throws IOException {
            return new Point2D.Float(0.0f, 0.0f);
        }

        @Override
        public void closePath() throws IOException {
        }

        @Override
        public void endPath() throws IOException {
        }

        @Override
        protected void showGlyph(Matrix textRenderingMatrix, PDFont font, int code, Vector displacement) throws IOException {
            PDGraphicsState graphicsState = this.getGraphicsState();
            RenderingMode renderingMode = graphicsState.getTextState().getRenderingMode();
            if (renderingMode.isFill()) {
                this.processColor(graphicsState.getNonStrokingColor());
            }
            if (renderingMode.isStroke()) {
                this.processColor(graphicsState.getStrokingColor());
            }
        }

        @Override
        public void strokePath() throws IOException {
            this.processColor(this.getGraphicsState().getStrokingColor());
        }

        @Override
        public void fillPath(int windingRule) throws IOException {
            this.processColor(this.getGraphicsState().getNonStrokingColor());
        }

        @Override
        public void fillAndStrokePath(int windingRule) throws IOException {
            this.processColor(this.getGraphicsState().getNonStrokingColor());
        }

        @Override
        public void shadingFill(COSName shadingName) throws IOException {
        }

        private void processColor(PDColor color) throws IOException {
            PDPattern pattern;
            PDAbstractPattern abstractPattern;
            if (color.getColorSpace() instanceof PDPattern && (abstractPattern = (pattern = (PDPattern)color.getColorSpace()).getPattern(color)) instanceof PDTilingPattern) {
                this.processTilingPattern((PDTilingPattern)abstractPattern, null, null);
            }
        }

        private void write2file(PDImage pdImage, String prefix, boolean directJPEG, boolean noColorConvert) throws IOException {
            BufferedImage image;
            String suffix = pdImage.getSuffix();
            if (suffix == null || "jb2".equals(suffix)) {
                suffix = "png";
            } else if ("jpx".equals(suffix)) {
                suffix = "jp2";
            }
            if (this.hasMasks(pdImage)) {
                suffix = "png";
            }
            if (noColorConvert && (image = pdImage.getRawImage()) != null) {
                int elements = image.getRaster().getNumDataElements();
                suffix = "png";
                if (elements > 3) {
                    suffix = "tiff";
                }
                try (FileOutputStream imageOutput = new FileOutputStream(prefix + "." + suffix);){
                    ExtractImages.this.SYSOUT.println("Writing image: " + prefix + "." + suffix);
                    ImageIOUtil.writeImage(image, suffix, imageOutput);
                    imageOutput.flush();
                }
                return;
            }
            try (FileOutputStream imageOutput = new FileOutputStream(prefix + "." + suffix);){
                BufferedImage image2;
                String colorSpaceName;
                ExtractImages.this.SYSOUT.println("Writing image: " + prefix + "." + suffix);
                if ("jpg".equals(suffix)) {
                    colorSpaceName = pdImage.getColorSpace().getName();
                    if (directJPEG || PDDeviceGray.INSTANCE.getName().equals(colorSpaceName) || PDDeviceRGB.INSTANCE.getName().equals(colorSpaceName)) {
                        InputStream data = pdImage.createInputStream(JPEG);
                        IOUtils.copy(data, imageOutput);
                        IOUtils.closeQuietly(data);
                    } else {
                        BufferedImage image3 = pdImage.getImage();
                        if (image3 != null) {
                            ImageIOUtil.writeImage(image3, suffix, imageOutput);
                        }
                    }
                } else if ("jp2".equals(suffix)) {
                    colorSpaceName = pdImage.getColorSpace().getName();
                    if (directJPEG || PDDeviceGray.INSTANCE.getName().equals(colorSpaceName) || PDDeviceRGB.INSTANCE.getName().equals(colorSpaceName)) {
                        InputStream data = pdImage.createInputStream(Collections.singletonList(COSName.JPX_DECODE.getName()));
                        IOUtils.copy(data, imageOutput);
                        IOUtils.closeQuietly(data);
                    } else {
                        BufferedImage image4 = pdImage.getImage();
                        if (image4 != null) {
                            ImageIOUtil.writeImage(image4, "jpeg2000", imageOutput);
                        }
                    }
                } else if ("tiff".equals(suffix) && pdImage.getColorSpace().equals(PDDeviceGray.INSTANCE)) {
                    image2 = pdImage.getImage();
                    if (image2 == null) {
                        return;
                    }
                    int w = image2.getWidth();
                    int h = image2.getHeight();
                    BufferedImage bitonalImage = new BufferedImage(w, h, 12);
                    for (int y = 0; y < h; ++y) {
                        for (int x = 0; x < w; ++x) {
                            bitonalImage.setRGB(x, y, image2.getRGB(x, y));
                        }
                    }
                    ImageIOUtil.writeImage(bitonalImage, suffix, imageOutput);
                } else {
                    image2 = pdImage.getImage();
                    if (image2 != null) {
                        ImageIOUtil.writeImage(image2, suffix, imageOutput);
                    }
                }
                imageOutput.flush();
            }
        }

        private boolean hasMasks(PDImage pdImage) throws IOException {
            if (pdImage instanceof PDImageXObject) {
                PDImageXObject ximg = (PDImageXObject)pdImage;
                return ximg.getMask() != null || ximg.getSoftMask() != null;
            }
            return false;
        }
    }
}

