/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.pdf.shade.org.apache.pdfbox.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.dromara.pdf.shade.org.apache.pdfbox.Loader;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDDocument;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.dromara.pdf.shade.org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.dromara.pdf.shade.org.apache.pdfbox.tools.Version;
import picocli.CommandLine;

@CommandLine.Command(name="importfdf", header={"Imports AcroForm form data from FDF"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public class ImportFDF
implements Callable<Integer> {
    private final PrintStream SYSERR = System.err;
    @CommandLine.Option(names={"-i", "--input"}, description={"the PDF file to import to"}, required=true)
    private File infile;
    @CommandLine.Option(names={"-o", "--output"}, description={"the PDF file to save to. If omitted the original file will be used"})
    private File outfile;
    @CommandLine.Option(names={"--data"}, description={"the FDF data file to import from"}, required=true)
    private File fdffile;

    public void importFDF(PDDocument pdfDocument, FDFDocument fdfDocument) throws IOException {
        PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm();
        if (acroForm == null) {
            return;
        }
        acroForm.setCacheFields(true);
        acroForm.importFDF(fdfDocument);
        acroForm.setNeedAppearances(true);
    }

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine((Object)new ImportFDF()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() {
        ImportFDF importer = new ImportFDF();
        try (PDDocument pdf = Loader.loadPDF(this.infile);
             FDFDocument fdf = Loader.loadFDF(this.fdffile);){
            importer.importFDF(pdf, fdf);
            if (this.outfile == null) {
                this.outfile = this.infile;
            }
            pdf.save(this.outfile);
        }
        catch (IOException ioe) {
            this.SYSERR.println("Error importing FDF data [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
            return 4;
        }
        return 0;
    }
}

