/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.ai.llm.dialect.dashscope;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.noear.snack.ONode;
import org.noear.solon.Utils;
import org.noear.solon.ai.AiUsage;
import org.noear.solon.ai.rag.Document;
import org.noear.solon.ai.reranking.Reranking;
import org.noear.solon.ai.reranking.RerankingConfig;
import org.noear.solon.ai.reranking.RerankingException;
import org.noear.solon.ai.reranking.RerankingOptions;
import org.noear.solon.ai.reranking.RerankingResponse;
import org.noear.solon.ai.reranking.dialect.AbstractRerankingDialect;

public class DashscopeRerankingDialect
extends AbstractRerankingDialect {
    private static DashscopeRerankingDialect instance = new DashscopeRerankingDialect();

    public static DashscopeRerankingDialect getInstance() {
        return instance;
    }

    public boolean matched(RerankingConfig config) {
        return "dashscope".equals(config.getProvider());
    }

    public String buildRequestJson(RerankingConfig config, RerankingOptions options, String query, List<Document> documents) {
        return new ONode().build(n -> {
            if (Utils.isNotEmpty((String)config.getModel())) {
                n.set("model", (Object)config.getModel());
            }
            n.getOrNew("input").build(n1 -> {
                n1.set("query", (Object)query);
                n1.getOrNew("documents").build(n2 -> {
                    for (Document doc : documents) {
                        n2.add((Object)doc.getContent());
                    }
                });
            });
            for (Map.Entry kv : options.options().entrySet()) {
                n.set((String)kv.getKey(), kv.getValue());
            }
        }).toJson();
    }

    public RerankingResponse parseResponseJson(RerankingConfig config, String respJson) {
        ONode oResp = ONode.load((Object)respJson);
        String model = oResp.get("model").getString();
        if (oResp.contains("message")) {
            return new RerankingResponse(model, new RerankingException(oResp.get("message").getString()), null, null);
        }
        ArrayList<Reranking> results = new ArrayList<Reranking>();
        for (ONode n1 : oResp.get("output").get("results").ary()) {
            Reranking r1 = new Reranking(n1.get("index").getInt(), n1.get("document").get("text").getString(), n1.get("relevance_score").getFloat());
            results.add(r1);
        }
        AiUsage usage = null;
        if (oResp.contains("usage")) {
            ONode oUsage = oResp.get("usage");
            int total_tokens = oUsage.get("total_tokens").getInt();
            usage = new AiUsage((long)total_tokens, 0L, (long)total_tokens);
        }
        return new RerankingResponse(model, null, results, usage);
    }
}

