/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.web.sse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import org.noear.solon.core.util.ConsumerEx;
import org.noear.solon.web.sse.SseEmitterHandler;
import org.noear.solon.web.sse.SseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SseEmitter {
    static final Logger log = LoggerFactory.getLogger(SseEmitter.class);
    private SseEmitterHandler eventHandler;
    private List<SseEvent> eventCached = new ArrayList<SseEvent>();
    protected Runnable onCompletion;
    protected Runnable onTimeout;
    protected Function<SseEvent, SseEvent> onSendPost;
    protected Consumer<Throwable> onError;
    protected ConsumerEx<SseEmitter> onInited;
    protected long timeout;
    private final AtomicBoolean completed = new AtomicBoolean(false);

    public SseEmitter onCompletion(Runnable onCompletion) {
        this.onCompletion = onCompletion;
        return this;
    }

    public SseEmitter onTimeout(Runnable onTimeout) {
        this.onTimeout = onTimeout;
        return this;
    }

    public SseEmitter onSendPost(Function<SseEvent, SseEvent> onSendPost) {
        this.onSendPost = onSendPost;
        return this;
    }

    public SseEmitter onError(Consumer<Throwable> onError) {
        this.onError = onError;
        return this;
    }

    public SseEmitter onInited(ConsumerEx<SseEmitter> onInited) {
        this.onInited = onInited;
        return this;
    }

    public SseEmitter(long timeout) {
        this.timeout = timeout;
    }

    public void send(String data) throws IOException {
        this.send(new SseEvent().data(data));
    }

    public void send(SseEvent event) throws IOException {
        if (this.onSendPost != null) {
            event = this.onSendPost.apply(event);
        }
        if (event != null) {
            if (this.eventHandler == null) {
                this.eventCached.add(event);
            } else {
                this.eventHandler.send(event);
            }
        }
    }

    public boolean isCompleted() {
        return this.completed.get();
    }

    public void complete() {
        try {
            this.completed.set(true);
            if (this.eventHandler != null) {
                this.eventHandler.complete();
                this.eventHandler = null;
            }
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    protected void initialize(SseEmitterHandler handler) throws Throwable {
        this.eventHandler = handler;
        for (SseEvent event : this.eventCached) {
            this.eventHandler.send(event);
        }
        if (this.onInited != null) {
            this.onInited.accept((Object)this);
        }
        if (this.completed.get()) {
            this.complete();
        }
    }
}

